@extends($_frameLayoutView)

@section('pageTitle',$news['title'])
@section('pageKeywords',$news['title'])
@section('pageDescription',$news['title'])

@section('body')

    @include(\Edwin404\Tecmz\View\TemplateUtil::view('pc.header'),['mini'=>true])

    <div class="pb-page-background">
        <div class="background"
             style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($background['url'])}})">
            <div class="title">新闻中心</div>
        </div>
    </div>

    <div class="pb-news-view">
        <div class="pb-container">
            <div class="title">{{$news['title']}}</div>
            <div class="info">
                发布时间: {{\Carbon\Carbon::parse($news['created_at'])->toDateString()}}
                点击数: {{$news['click']}}
            </div>
            <div class="content html-container">
                {!! \Edwin404\Base\Support\HtmlHelper::replaceImageSrcToLazyLoad($news['content'],'data-src',true) !!}
            </div>
        </div>
    </div>

    @include('theme.default.pc.footer')

    @if(\Edwin404\Config\Facades\ConfigFacade::get('moduleBookEnable',false))
        @include('theme.default.pc.book')
    @endif

@endsection
