@extends($_frameLayoutView)

@section('pageTitle','产品中心 - '.\Edwin404\Config\Facades\ConfigFacade::get('siteName'))
@section('pageKeywords','产品中心,'.\Edwin404\Config\Facades\ConfigFacade::get('siteKeywords'))
@section('pageDescription','产品中心,'.\Edwin404\Config\Facades\ConfigFacade::get('siteDescription'))

@section('body')

    @include(\Edwin404\Tecmz\View\TemplateUtil::view('pc.header'),['mini'=>true])

    <div class="pb-page-background">
        <div class="background"
             style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($background['url'])}})">
            <div class="title">产品中心</div>
        </div>
    </div>

    <div class="pb-product-category">
        <div class="pb-container">
            <div class="list">
                <a href="/product" class="item @if(empty($currentCategory)) active @endif">全部</a>
                @foreach($categories as $category)
                    <a href="/product/category/{{$category['id']}}" class="item @if($currentCategory && $currentCategory['id']==$category['id']) active @endif">{{$category['title']}}</a>
                @endforeach
            </div>
        </div>
    </div>

    <div class="pb-news-list">
        <div class="pb-container">
            @if(count($products))
                <div class="uk-grid">
                    @foreach($products as $product)
                        <div class="uk-width-medium-1-3">
                            <a class="item" href="/product/{{$product['id']}}">
                                <div class="cover t-item-ratio-1-1" data-src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($product['cover'])}}"></div>
                                <div class="info">
                                    <div class="title uk-text-truncate">
                                        {{$product['title']}}
                                    </div>
                                    <div class="desc">
                                        {{$product['description']}}
                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
                <div class="pb-page">
                    <div class="page-container">
                        {!! $pageHtml !!}
                    </div>
                </div>
            @else
                <div class="pb-empty">暂无内容</div>
            @endif
        </div>
    </div>

    @include('theme.default.pc.footer')

    @if(\Edwin404\Config\Facades\ConfigFacade::get('moduleBookEnable',false))
        @include('theme.default.pc.book')
    @endif

@endsection
