@extends($_frameLayoutView)

@section('pageTitle',$product['title'])
@section('pageKeywords',$product['title'])
@section('pageDescription',$product['title'])

@section('body')

    @include(\Edwin404\Tecmz\View\TemplateUtil::view('pc.header'),['mini'=>true])

    <div class="pb-page-background">
        <div class="background"
             style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($background['url'])}})">
            <div class="title">产品中心</div>
        </div>
    </div>

    <div class="pb-product-view">
        <div class="pb-container">
            <div class="uk-grid">
                <div class="uk-width-medium-1-2">
                    <div class="cover">
                        <img data-src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($product['cover'])}}" />
                    </div>
                </div>
                <div class="uk-width-medium-1-2">
                    <div class="title">{{$product['title']}}</div>
                    <div class="info">
                        <div class="line">
                            @if($product['price'])
                                <div class="item">
                                    <span>参考价格：</span> {{sprintf('%.2f',$product['price'])}} 元
                                </div>
                            @endif
                        </div>
                        <div class="line">
                            <a class="uk-button uk-button-main" target="_blank" href="/contact">联系购买</a>
                            @if(\Edwin404\Config\Facades\ConfigFacade::get('contactQQ'))
                                <a class="uk-button uk-button-main" href="http://wpa.qq.com/msgrd?v=3&uin={{\Edwin404\Config\Facades\ConfigFacade::get('contactQQ')}}&site=oicqzone.com&menu=yes" target="_blank">联系QQ购买</a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="content html-container">
                {!! \Edwin404\Base\Support\HtmlHelper::replaceImageSrcToLazyLoad($product['content'],'data-src',true) !!}
            </div>
        </div>
    </div>

    @include('theme.default.pc.footer')

    @if(\Edwin404\Config\Facades\ConfigFacade::get('moduleBookEnable',false))
        @include('theme.default.pc.book')
    @endif

@endsection
