<div id="app" v-cloak>
    <div class="admin-form">
        <table>
            <tbody>
            <tr>
                <td width="100">
                    <div class="line">
                        排序
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-input v-model="sort"/>
                    </div>
                </td>
            </tr>
            <tr>
                <td width="100">
                    <div class="line">
                        标题
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-input v-model="content.title"/>
                    </div>
                </td>
            </tr>
            <tr>
                <td width="100">
                    <div class="line">
                        副标题
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-input v-model="content.subTitle"/>
                    </div>
                </td>
            </tr>
            <tr>
                <td width="100">
                    <div class="line">
                        每行个数
                    </div>
                </td>
                <td>
                    <div class="line">
                        <span>
                            电脑端：
                            <input-number :max="5" :min="1" v-model="content.pcRowCount"/>
                        </span>
                        <span>
                            手机端：
                            <input-number :max="5" :min="1" v-model="content.mRowCount"/>
                        </span>
                    </div>
                </td>
            </tr>
            <tr>
                <td width="100">
                    <div class="line">
                        图片比例
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-select v-model="content.ratio">
                            <i-option value="2-1">宽:高 = 2:1</i-option>
                            <i-option value="5-3">宽:高 = 5:3</i-option>
                            <i-option value="1-1">宽:高 = 1:1</i-option>
                            <i-option value="3-5">宽:高 = 3:5</i-option>
                            <i-option value="1-2">宽:高 = 1:2</i-option>
                        </i-select>
                    </div>
                </td>
            </tr>
            <tr>
                <td width="100">
                    <div class="line">
                        遮罩层悬浮效果
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-switch v-model="content.maskAutoHide" />
                    </div>
                </td>
            </tr>
            <tr v-for="(item,itemIndex) in content.list" data-category-item>
                <td>
                    <div class="line">
                        <div>
                            <i-input v-model="content.list[itemIndex].title" placeholder="分类名称"/>
                        </div>
                        <div>
                            <Checkbox v-model="content.list[itemIndex].isLink">链接</Checkbox>
                        </div>
                    </div>
                </td>
                <td>
                    <div v-if="content.list[itemIndex].isLink">
                        <div class="line">
                            <div class="uk-grid">
                                <div class="uk-width-3-4">
                                    <i-input v-model="content.list[itemIndex].link"/>
                                </div>
                                <div class="uk-width-1-4">
                                    <a href="javascript:;" class="uk-button" @click="doSelectLink(itemIndex)"><i class="uk-icon-link"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <table v-if="!content.list[itemIndex].isLink">
                        <tbody>
                        <tr v-for="(itemItem,itemItemIndex) in item.list">
                            <td>
                                <div class="line">
                                    图文@{{itemItemIndex+1}}
                                    <a href="javascript:;" @click="content.list[itemIndex].list.splice(itemItemIndex,1)"><i class="uk-icon-trash"></i></a>
                                </div>
                            </td>
                            <td>
                                <div class="line">
                                    <div class="label">
                                        图片
                                    </div>
                                    <div class="field">
                                        <div data-image-widget data-list-image>
                                            <input type="hidden" name="_empty_" data-image
                                                   :value="content.list[itemIndex].list[itemItemIndex].image"/>
                                            <span class="image" style="background-image:url('');"></span>
                                            <span class="add"><i class="uk-icon-plus"></i></span>
                                            <span class="delete"><i class="uk-icon-remove"></i></span>
                                        </div>
                                    </div>
                                    <div class="label">
                                        主标题
                                    </div>
                                    <div class="field">
                                        <i-input v-model="content.list[itemIndex].list[itemItemIndex].title"/>
                                    </div>
                                    <div class="label">
                                        副标题
                                    </div>
                                    <div class="field">
                                        <i-input v-model="content.list[itemIndex].list[itemItemIndex].subTitle"/>
                                    </div>
                                    <div class="label">
                                        按钮文字
                                    </div>
                                    <div class="field">
                                        <i-input v-model="content.list[itemIndex].list[itemItemIndex].buttonText"/>
                                    </div>
                                    <div class="label">
                                        按钮链接
                                    </div>
                                    <div class="field">
                                        <div class="uk-grid">
                                            <div class="uk-width-3-4">
                                                <i-input v-model="content.list[itemIndex].list[itemItemIndex].buttonUrl"/>
                                            </div>
                                            <div class="uk-width-1-4">
                                                <a href="javascript:;" class="uk-button" @click="doSelectButtonLink(itemIndex,itemItemIndex)"><i class="uk-icon-link"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <div class="line">
                                    <a href="javascript:;"
                                       @click="content.list[itemIndex].list.push({image:'',title:'',subTitle:'',buttonText:'',buttonUrl:''});initDom();">
                                        <i class="uk-icon-plus"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <div class="line">
                        <a href="javascript:;" @click="content.list.push({title:'',isLink:false,link:'',list:[]})">
                            <i class="uk-icon-plus"></i> 增加分类
                        </a>
                    </div>
                </td>
            </tr>
            </tbody>
            <tbody>
            <tr>
                <td colspan="2">
                    <div class="line">
                        <i-button type="primary" @click="doSubmit()">保存</i-button>
                        <i-button @click="doBack()">返回</i-button>
                    </div>
                </td>
            </tr>
            </tbody>
        </table>
    </div>

</div>

<script>
    $(function () {
        var app = new Vue({
            el: '#app',
            data: {
                sort:{{ json_encode($itemSort) }},
                content: {
                    title: @jsonString($itemContent['title']),
                    subTitle: @jsonString($itemContent['subTitle']),
                    pcRowCount: @jsonNumber($itemContent['pcRowCount']),
                    mRowCount: @jsonNumber($itemContent['mRowCount']),
                    ratio: @jsonString($itemContent['ratio']),
                    maskAutoHide: @jsonBoolean($itemContent['maskAutoHide']),
                    list: @jsonArray($itemContent['list'])
                },
            },
            mounted:function(){
                for(var i=0;i<content.list.length;i++){
                    if(!('isLink' in content.list[i])){
                        content.list[i].isLink = false
                    }
                    if(!('link' in content.list[i])){
                        content.list[i].link = ''
                    }
                }
            },
            methods: {
                doSelectLink:function(itemIndex){
                    window.__commonSelectDialog = window.api.commonSelectDialog({
                        limitMax: 1,
                        limitMin: 1,
                        server: '{{ action('\App\Http\Controllers\Admin\WidgetController@linkSelectDialog') }}',
                        callback: function (items, items_) {
                            if(items.length>0){
                                app.content.list[itemIndex].link = items[0]
                            }
                        }
                    });
                    window.__commonSelectDialog.show();
                },
                doSelectButtonLink:function(itemIndex,itemItemIndex){
                    window.__commonSelectDialog = window.api.commonSelectDialog({
                        limitMax: 1,
                        limitMin: 1,
                        server: '{{ action('\App\Http\Controllers\Admin\WidgetController@linkSelectDialog') }}',
                        callback: function (items, items_) {
                            if(items.length>0){
                                app.content.list[itemIndex].list[itemItemIndex].buttonUrl = items[0]
                            }
                        }
                    });
                    window.__commonSelectDialog.show();
                },
                initDom: function () {
                    setTimeout(function () {
                        $('[data-category-item]').each(function (ii, oo) {
                            $(oo).find('[data-list-image]').each(function (i, o) {
                                $(o).imageWidget().init()
                                $(o).off('image-widget.change').on('image-widget.change', function (event, value) {
                                    app.content.list[ii].list[i].image = value
                                })
                            })
                        })
                    }, 100);
                },
                init: function () {
                    this.initDom()
                },
                doSubmit: function () {
                    window.api.dialog.loadingOn();
                    window.api.base.post('?', {content: JSON.stringify(this.content), sort: this.sort}, function (res) {
                        window.api.dialog.loadingOff();
                        window.api.base.defaultFormCallback(res);
                    })
                },
                doBack: function () {
                    window.history.back()
                }
            },
            mounted: function () {
                var me = this;
                setTimeout(function () {
                    me.init();
                }, 100);
            }
        });
    });
</script>
