<div class="pb-sp-item pb-sp-item-category-list-a" id="SuperPageItem_{{$id}}">
    <div class="t-title">{{$content['title'] or ''}}</div>
    <div class="t-sub-title">{{$content['subTitle'] or ''}}</div>
    <div class="category">
        @foreach($content['list'] as $categoryIndex=>$category)
            @if(!empty($category['isLink']))
                <a href="{{$category['link']}}" class="item link">
                    {{$category['title']}}
                </a>
            @else
                <a href="javascript:;" class="item @if($categoryIndex==0) active @endif">
                    {{$category['title']}}
                </a>
            @endif
        @endforeach
    </div>
    <div class="t-list">
        @foreach($content['list'] as $categoryIndex=>$category)
            <div class="item @if($categoryIndex==0) active @endif">
                <div class="uk-grid">
                    @foreach($category['list'] as $item)
                        <div class="uk-width-1-{{$content['mRowCount']}} uk-width-medium-1-{{$content['pcRowCount']}}">
                            <div class="t-item t-item-ratio-{{$content['ratio']}} @if(!empty($content['maskAutoHide'])) t-item-mask-auto-hide @endif"
                                 data-src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($item['image'])}}">
                                <div class="mask">
                                    <div class="content">
                                        <div class="title">{{$item['title']}}</div>
                                        <div class="sub-title">{{$item['subTitle']}}</div>
                                        @if($item['buttonText'])
                                            <div class="button">
                                                <a href="{{$item['buttonUrl']}}">{{$item['buttonText']}}</a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach
    </div>
</div>
<script>
    $(function () {
        var $items = $('#SuperPageItem_{{$id}}').find('.category .item');
        var $contents = $('#SuperPageItem_{{$id}}').find('.t-list .item');
        $items.on('click', function () {
            if ($(this).is('.link')) {
                return true;
            }
            $items.removeClass('active');
            $(this).addClass('active');
            $contents.removeClass('active').eq($items.index(this)).addClass('active');
            window.api.lazyLoad.init();
            return false;
        })
    })
</script>
