<div id="app" v-cloak>
    <div class="admin-form">
        <table>
            <tbody>
            <tr>
                <td width="100">
                    <div class="line">
                        排序
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-input v-model="sort"/>
                    </div>
                </td>
            </tr>
            <tr>
                <td width="100">
                    <div class="line">
                        标题
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-input v-model="content.title"/>
                    </div>
                </td>
            </tr>
            <tr>
                <td width="100">
                    <div class="line">
                        副标题
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-input v-model="content.subTitle"/>
                    </div>
                </td>
            </tr>
            {{--<tr>--}}
                {{--<td width="100">--}}
                    {{--<div class="line">--}}
                        {{--每行个数--}}
                    {{--</div>--}}
                {{--</td>--}}
                {{--<td>--}}
                    {{--<div class="line">--}}
                        {{--<span>--}}
                            {{--电脑端：--}}
                            {{--<input-number :max="5" :min="1" v-model="content.pcRowCount" />--}}
                        {{--</span>--}}
                        {{--<span>--}}
                            {{--手机端：--}}
                            {{--<input-number :max="5" :min="1" v-model="content.mRowCount" />--}}
                        {{--</span>--}}
                    {{--</div>--}}
                {{--</td>--}}
            {{--</tr>--}}
            <tr>
                <td width="100">
                    <div class="line">
                        图片比例
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-select v-model="content.ratio">
                            <i-option value="6-1">宽:高 = 6:1</i-option>
                            <i-option value="3-1">宽:高 = 3:1</i-option>
                            <i-option value="5-3">宽:高 = 5:3</i-option>
                            <i-option value="1-1">宽:高 = 1:1</i-option>
                        </i-select>
                    </div>
                </td>
            </tr>
            <tr v-for="(item,itemIndex) in content.list">
                <td>
                    <div class="line">
                        联系方式@{{itemIndex+1}}
                        <a href="javascript:;" @click="content.list.splice(itemIndex,1)"><i class="uk-icon-trash"></i></a>
                    </div>
                </td>
                <td>
                    <div class="line">
                        <div class="label">
                            图片
                        </div>
                        <div class="field">
                            <div data-image-widget data-list-image>
                                <input type="hidden" name="_empty_" data-image :value="content.list[itemIndex].image"/>
                                <span class="image" style="background-image:url('');"></span>
                                <span class="add"><i class="uk-icon-plus"></i></span>
                                <span class="delete"><i class="uk-icon-remove"></i></span>
                            </div>
                        </div>
                        <div class="label">
                            联系名称
                        </div>
                        <div class="field">
                            <i-input v-model="content.list[itemIndex].name"/>
                        </div>
                        <div class="label">
                            联系方式
                        </div>
                        <div class="field">
                            <i-input v-model="content.list[itemIndex].value"/>
                        </div>
                        <div class="label">
                            显示类型
                        </div>
                        <div class="field">
                            <radio-group v-model="content.list[itemIndex].type">
                                <Radio label="text">普通文本</Radio>
                                <Radio label="phone">电话</Radio>
                            </radio-group>
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <div class="line">
                        <a href="javascript:;" @click="content.list.push({image:'',name:'',value:''});initDom();">
                            <i class="uk-icon-plus"></i>
                        </a>
                    </div>
                </td>
            </tr>
            </tbody>
            <tbody>
            <tr>
                <td colspan="2">
                    <div class="line">
                        <i-button type="primary" @click="doSubmit()">保存</i-button>
                        <i-button @click="doBack()">返回</i-button>
                    </div>
                </td>
            </tr>
            </tbody>
        </table>
    </div>

</div>

<script>
    $(function () {
        var app = new Vue({
            el: '#app',
            data: {
                sort:{{ json_encode($itemSort) }},
                content:{
                    title: @jsonString($itemContent['title']),
                    subTitle: @jsonString($itemContent['subTitle']),
                    pcRowCount: @jsonNumber($itemContent['pcRowCount']),
                    mRowCount: @jsonNumber($itemContent['mRowCount']),
                    ratio: @jsonString($itemContent['ratio']),
                    list: @jsonArray($itemContent['list'])
                },
            },
            mounted:function(){
                for(var i=0;i<content.list.length;i++){
                    if(!('type' in content.list[i])){
                        content.list[i].type = ''
                    }
                }
            },
            methods: {
                initDom: function () {
                    setTimeout(function () {
                        $('[data-list-image]').each(function (i, o) {
                            $(o).imageWidget().init()
                            $(o).off('image-widget.change').on('image-widget.change', function (event, value) {
                                app.content.list[i].image = value
                            })
                        })
                    }, 100);
                },
                init: function () {
                    this.initDom()
                },
                doSubmit: function () {
                    window.api.dialog.loadingOn();
                    window.api.base.post('?', {content: JSON.stringify(this.content),sort:this.sort}, function (res) {
                        window.api.dialog.loadingOff();
                        window.api.base.defaultFormCallback(res);
                    })
                },
                doBack:function () {
                    window.history.back()
                }
            },
            mounted: function () {
                var me = this;
                setTimeout(function () {
                    me.init();
                }, 100);
            }
        });
    });
</script>
