<div id="app" v-cloak>
    <div class="admin-form">
        <table>
            <tbody>
            <tr>
                <td width="100">
                    <div class="line">
                        排序
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-input v-model="sort"/>
                    </div>
                </td>
            </tr>
            <tr>
                <td width="100">
                    <div class="line">
                        标题
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-input v-model="content.title"/>
                    </div>
                </td>
            </tr>
            <tr>
                <td width="100">
                    <div class="line">
                        副标题
                    </div>
                </td>
                <td>
                    <div class="line">
                        <i-input v-model="content.subTitle"/>
                    </div>
                </td>
            </tr>
            <tr>
                <td width="100">
                    <div class="line">
                        图片
                    </div>
                </td>
                <td>
                    <div class="line">
                        <div data-image-widget data-list-image>
                            <input type="hidden" name="_empty_" data-image :value="content.image"/>
                            <span class="image" style="background-image:url('');"></span>
                            <span class="add"><i class="uk-icon-plus"></i></span>
                            <span class="delete"><i class="uk-icon-remove"></i></span>
                        </div>
                    </div>
                </td>
            </tr>
            </tbody>
            <tbody>
            <tr>
                <td colspan="2">
                    <div class="line">
                        <i-button type="primary" @click="doSubmit()">保存</i-button>
                        <i-button @click="doBack()">返回</i-button>
                    </div>
                </td>
            </tr>
            </tbody>
        </table>
    </div>

</div>

<script>
    $(function () {
        var app = new Vue({
            el: '#app',
            data: {
                sort:{{ json_encode($itemSort) }},
                content:{
                    title: @jsonString($itemContent['title']),
                    subTitle: @jsonString($itemContent['subTitle']),
                    image: @jsonString($itemContent['image'])
                },
            },
            mounted:function(){
                for(var i=0;i<content.list.length;i++){
                    if(!('type' in content.list[i])){
                        content.list[i].type = ''
                    }
                }
            },
            methods: {
                initDom: function () {
                    setTimeout(function () {
                        $('[data-list-image]').each(function (i, o) {
                            $(o).imageWidget().init()
                            $(o).off('image-widget.change').on('image-widget.change', function (event, value) {
                                app.content.image = value
                            })
                        })
                    }, 100);
                },
                init: function () {
                    this.initDom()
                },
                doSubmit: function () {
                    window.api.dialog.loadingOn();
                    window.api.base.post('?', {content: JSON.stringify(this.content),sort:this.sort}, function (res) {
                        window.api.dialog.loadingOff();
                        window.api.base.defaultFormCallback(res);
                    })
                },
                doBack:function () {
                    window.history.back()
                }
            },
            mounted: function () {
                var me = this;
                setTimeout(function () {
                    me.init();
                }, 100);
            }
        });
    });
</script>
