<?php

namespace Edwin404\Base\Support;


use Illuminate\Support\Str;

class CurlHelper
{
    public static function postContent($url, $param = [], $config = [])
    {
        if (empty($config['timeout'])) {
            $config['timeout'] = 30;
        }
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, $config['timeout']);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
        if (Str::startsWith($url, 'https://')) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        }
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }

    public static function postContentWithHeaders($url, $param = [], $headers = [])
    {
        $sendHeaders = [];
        foreach ($headers as $k => $v) {
            $sendHeaders[] = "$k: $v";
        }

        $ch = curl_init($url);

        // curl_setopt($ch, CURLOPT_VERBOSE, true);
        // $fp = fopen(base_path('curl.txt'), 'w');
        // curl_setopt($ch, CURLOPT_STDERR, $fp);

        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $sendHeaders);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
        if (Str::startsWith($url, 'https://')) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        }
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }

    public static function postStandardJson($url, $param)
    {
        $content = self::postContent($url, $param);
        if (empty($content)) {
            return Response::generate(-1, '获取数据失败');
        }
        $contentJson = @json_decode($content, true);
        if (!isset($contentJson['code'])) {
            return Response::generate(-1, '获取数据失败', $contentJson);
        }
        return $contentJson;
    }

    public static function getContent($url, $param = [], $config = [])
    {
        if (empty($config['timeout'])) {
            $config['timeout'] = 30;
        }
        if (!empty($param)) {
            $url = $url . '?' . http_build_query($param);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, $config['timeout']);
        curl_setopt($ch, CURLOPT_REFERER, $url);
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        if (Str::startsWith($url, 'https://')) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        }
        $temp = curl_exec($ch);
        curl_close($ch);
        return $temp;
    }

    public static function getContentWithHeaders($url, $param = [], $headers = [])
    {
        $sendHeaders = [];
        foreach ($headers as $k => $v) {
            $sendHeaders[] = "$k: $v";
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . "?" . http_build_query($param));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $sendHeaders);
        curl_setopt($ch, CURLOPT_FAILONERROR, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        if (Str::startsWith($url, 'https://')) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        }
        $temp = curl_exec($ch);
        curl_close($ch);
        return $temp;
    }

    public static function getStandardJson($url, $param = [])
    {
        $content = self::getContent($url, $param);
        if (empty($content)) {
            return Response::generate(-1, '获取数据失败');
        }
        $contentJson = @json_decode($content, true);
        if (!isset($contentJson['code'])) {
            return Response::generate(-1, '获取数据失败', $contentJson);
        }
        return $contentJson;
    }

    public static function getHeaderAndContent($url)
    {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_REFERER, $url);
        if (Str::startsWith($url, 'https://')) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        }
        $temp = curl_exec($ch);

        if (curl_getinfo($ch, CURLINFO_HTTP_CODE) != '200') {
            return null;
        }
        $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $headerString = substr($temp, 0, $headerSize);
        $body = substr($temp, $headerSize);
        curl_close($ch);

        $header = [];
        foreach (explode("\n", $headerString) as $line) {
            $line = trim($line);
            if (preg_match('/^(.*?):(.*?)$/', $line, $mat)) {
                $header[] = [
                    strtolower(trim($mat[1])) => trim($mat[2])
                ];
            }
        }

        return [
            'header' => $header,
            'body' => $body,
        ];
    }

    public static function request($url, $param, $option = [])
    {
        $sendHeaders = [];
        if (!empty($option['header'])) {
            foreach ($option['header'] as $k => $v) {
                $sendHeaders[] = "$k:$v";
            }
        }
        $returnHeader = false;
        if (!empty($option['returnHeader'])) {
            $returnHeader = true;
        }
        if (!isset($option['method'])) {
            $option['method'] = 'get';
        }

        $result = [];
        $result['body'] = null;
        if ($returnHeader) {
            $result['header'] = [];
        }
        if ($option['method'] == 'get') {
            $url = $url . '?' . http_build_query($param);
        }
        $ch = curl_init($url);

        if (!empty($option['debugFile'])) {
            curl_setopt($ch, CURLOPT_VERBOSE, true);
            $fp = fopen($option['debugFile'], 'w');
            curl_setopt($ch, CURLOPT_STDERR, $fp);
        }

        curl_setopt($ch, CURLOPT_HEADER, $returnHeader);
        if (!empty($sendHeaders)) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $sendHeaders);
        }
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        switch ($option['method']) {
            case 'post':
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
                break;
            case 'put':
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
                curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
                break;
        }
        if (Str::startsWith($url, 'https://')) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        }
        $output = curl_exec($ch);
        if (!empty($option['debugFile'])) {
            file_put_contents($option['debugFile'], "\n\n" . $output, FILE_APPEND);
        }
        if ($returnHeader) {
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            if ($httpCode != '200') {
                return $result;
            }
            $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $headerString = substr($output, 0, $headerSize);
            $result['body'] = substr($output, $headerSize);
            foreach (explode("\n", $headerString) as $line) {
                $line = trim($line);
                if (preg_match('/^(.*?):(.*?)$/', $line, $mat)) {
                    $result['header'] [] = [
                        trim($mat[1]) => trim($mat[2])
                    ];
                }
            }
        } else {
            $result['body'] = $output;
        }
        curl_close($ch);
        return $result;
    }

}
