<?php

namespace Edwin404\Api\Middleware;

use Edwin404\Api\Services\ApiSessionService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Response;

class ApiTokenCheckAndGenerate
{
    private $apiSessionService;

    function __construct(ApiSessionService $apiSessionService)
    {
        $this->apiSessionService = $apiSessionService;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @return mixed
     */
    public function handle($request, \Closure $next)
    {
        $apiToken = $this->get($request, 'api_token');
        if (empty($apiToken)) {
            $apiToken = $this->apiSessionService->getOrGenerateToken();
            header('api-token:' . $apiToken);
        }
        $request->headers->set('api-token', $apiToken);

        $apiDevice = $this->get($request, 'api_device');
        $request->headers->set('api-device', $apiDevice);

        $apiParam = $this->get($request, 'api_param');
        $request->headers->set('api-param', $apiParam);

        return $next($request);
    }

    // 获取顺序 (api_token,api_param,api_device)
    // 1. post 中
    // 2. get 中
    // 3. header 中
    // 4. cookie 中
    protected function get(Request &$request, $key)
    {
        $apiToken = Input::get($key, null);
        if (!empty($apiToken)) {
            return $apiToken;
        }
        $apiToken = $request->header(str_replace('_', '-', $key));
        if (!empty($apiToken)) {
            return $apiToken;
        }
        if (!empty($_COOKIE[$key])) {
            return $_COOKIE[$key];
        }
        $key = str_replace('_', '-', $key);
        if (!empty($_COOKIE[$key])) {
            return $_COOKIE[$key];
        }
        return null;
    }

}
