<?php

namespace Edwin404\Api\Services;

use Edwin404\Base\Support\ModelHelper;
use EdwinFound\Utils\RandomUtil;

class ApiAppService
{
    public function loadByAppId($appId)
    {
        return ModelHelper::load('api_app', ['appId' => $appId]);
    }

    public function load($id)
    {
        return ModelHelper::load('api_app', ['id' => $id]);
    }

    public function loadBy($where)
    {
        return ModelHelper::load('api_app', $where);
    }

    public function getNew($update)
    {
        $update['appId'] = RandomUtil::number(10);
        $update['appSecret'] = RandomUtil::string(32);
        $update = ModelHelper::add('api_app', $update);
        return ModelHelper::load('api_app', ['id' => $update['id']]);
    }
}
