<?php

namespace Edwin404\Firewall;


use Edwin404\Base\Support\Response;
use Edwin404\Config\Facades\ConfigFacade;
use Edwin404\Redis\RedisUtil;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Request;
use Symfony\Component\HttpFoundation\IpUtils;

class FirewallMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @return mixed
     */
    public function handle($request, \Closure $next)
    {
        if (RedisUtil::isEnable()) {
            $ip = Request::ip();
            if (ConfigFacade::get('systemVisitBlackListEnable', false)) {
                $list = ConfigFacade::get('systemVisitBlackList');
                foreach (explode("\n", $list) as $ipRange) {
                    $ipRange = trim($ipRange);
                    if (empty($ipRange)) {
                        continue;
                    }
                    if (IpUtils::checkIp4($ip, $ipRange)) {
                        Log::warning('Firewall.BlackList.Forbidden -> ' . $ipRange . ' - ' . $ip);
                        return 'Access Forbidden (B) !';
                    }
                }
            }
            if (ConfigFacade::get('systemVisitWhiteListEnable', false)) {
                $list = ConfigFacade::get('systemVisitWhiteList');
                $pass = false;
                foreach (explode("\n", $list) as $ipRange) {
                    $ipRange = trim($ipRange);
                    if (empty($ipRange)) {
                        continue;
                    }
                    if (IpUtils::checkIp4($ip, $ipRange)) {
                        $pass = true;
                        break;
                    }
                }
                if (!$pass) {
                    Log::warning('Firewall.WhiteList.Forbidden -> ' . $ipRange . ' - ' . $ip);
                    return 'Access Forbidden (W) !';
                }
            }
            $key = 'F:V:' . $ip;
            RedisUtil::incr($key);
            RedisUtil::expire($key, 3600 * 24);
        }
        return $next($request);
    }

}