<?php

namespace Edwin404\Firewall;


use Edwin404\Redis\RedisUtil;

class FirewallUtil
{
    public static function listVisitIps()
    {
        $ips = [];
        $redis = RedisUtil::client();
        try {
            $keys = $redis->keys('F:V:*');
            $fix = strlen('F:V:');
            foreach ($keys as $key) {
                try {
                    $ip = substr($key, $fix);
                    $ips[$ip] = intval($redis->get($key));
                } catch (\Exception $e) {
                    // 有时候由于延时造成不同步，这里忽略
                }
            }
        } catch (\Exception $e) {
        }
        arsort($ips, SORT_NUMERIC);
        return $ips;
    }
}