<?php

namespace Edwin404\Job;

use Edwin404\Base\Support\BaseJob;
use Edwin404\Log\Logger;
use Edwin404\Util\MailUtil;

class EmailSendJob extends BaseJob
{
    public $email;
    public $subject;
    public $template;
    public $templateData = [];
    public $emailUserName = null;
    public $option = [];

    public static function create($email, $subject, $template, $templateData = [], $emailUserName = null, $option = [], $delay = 0)
    {
        $job = new EmailSendJob();
        $job->email = $email;
        $job->subject = $subject;
        $job->template = $template;
        $job->templateData = $templateData;
        $job->emailUserName = $emailUserName;
        $job->option = $option;
        $job->onQueue('DefaultJob');
        if ($delay > 0) {
            $job->delay($delay);
        }
        app('Illuminate\Contracts\Bus\Dispatcher')->dispatch($job);
    }

    public function handle()
    {
        Logger::info('Email', 'Start', $this->email . ' -> ' . $this->subject . ' -> ' . $this->template);
        MailUtil::send($this->email, $this->subject, $this->template, $this->templateData, $this->emailUserName, $this->option);
        Logger::info('Email', 'End', $this->email . ' -> ' . $this->subject);
    }
}
