<?php

namespace Edwin404\Member\Services;


use Edwin404\Base\Support\ModelHelper;

class MemberConsigneeService
{
    public function loadWithUserId($memberUserId, $id)
    {
        return ModelHelper::load('member_consignee', ['id' => $id, 'memberUserId' => $memberUserId]);
    }

    public function delete($id)
    {
        ModelHelper::delete('member_consignee', ['id' => $id]);
    }

    public function update($id, $data)
    {
        return ModelHelper::updateOne('member_consignee', ['id' => $id], $data);
    }

    public function add($data)
    {
        return ModelHelper::add('member_consignee', $data);
    }

    public function listAllByUserId($memberUserId)
    {
        return ModelHelper::model('member_consignee')->where(['memberUserId' => $memberUserId])->orderBy('id', 'desc')->orderBy('isDefault', 'desc')->get()->toArray();
    }

    public function getDefault($memberUserId)
    {
        $consignee = ModelHelper::load('member_consignee', ['memberUserId' => $memberUserId, 'isDefault' => 1]);
        if (empty($consignee)) {
            $consignee = ModelHelper::load('member_consignee', ['memberUserId' => $memberUserId]);
        }
        return $consignee;
    }

    public function clearDefault($memberUserId)
    {
        ModelHelper::update('member_consignee', ['memberUserId' => $memberUserId], ['isDefault' => 0]);
    }

    public function truncate($memberUserId)
    {
        ModelHelper::delete('member_consignee', ['memberUserId' => $memberUserId]);
    }

}