<?php

namespace Edwin404\Shop\Jobs;

use Edwin404\Base\Support\BaseJob;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Shop\Events\ShopOrderExpireEvent;
use Edwin404\Shop\Types\OrderStatus;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Log;

class OrderExpireCheckJob extends BaseJob
{
    public $orderId;
    public $param;

    public static function create($orderId, $param = [], $delay = 0)
    {
        $job = new OrderExpireCheckJob();
        $job->orderId = $orderId;
        $job->param = $param;
        $job->onQueue('OrderExpireCheckJob');
        if ($delay > 0) {
            $job->delay($delay);
        }
        app('Illuminate\Contracts\Bus\Dispatcher')->dispatch($job);
    }

    public function handle()
    {
        Log::info('OrderExpireCheckJob.' . sprintf('%05d', getmypid()) . '.Execute ->' . $this->orderId . ' -> ' . json_encode($this->param));

        ModelHelper::transactionBegin();
        $order = ModelHelper::loadWithLock('order', ['id' => $this->orderId]);
        if (empty($order)) {
            ModelHelper::transactionCommit();
            return;
        }
        if ($order['status'] != OrderStatus::WAIT_PAY) {
            ModelHelper::transactionCommit();
            return;
        }
        OrderCancelJob::create($this->orderId, ['expire' => true]);
        ModelHelper::transactionCommit();
    }
}
