<?php

namespace Edwin404\Shop\Services;


use Edwin404\Base\Support\ModelHelper;
use EdwinFound\Utils\ArrayUtil;

class GoodsBuyerService
{
    public function paginateByGoodsId($goodsId, $page, $pageSize, $option = [])
    {
        $option['where']['goodsId'] = $goodsId;
        $paginateData = ModelHelper::modelPaginate('goods_buyer', $page, $pageSize, $option);
        ModelHelper::modelJoin($paginateData['records'], 'memberUserId', '_memberUser', 'member_user', 'id');
        $paginateData['records'] = collect($paginateData['records'])
            ->filter(function ($record) {
                return !empty($record['_memberUser']);
            })
            ->map(function ($record) {
                $item = array_only($record['_memberUser'], ['username', 'avatar']);
                $item['amount'] = $record['amount'];
                $item['created_at'] = $record['created_at'];
                return $item;
            })
            ->toArray();
        return $paginateData;
    }
}
