<?php

namespace Edwin404\Tecmz\Api;

use Edwin404\Base\Support\Response;
use Edwin404\Base\Support\InputPackage;
use Edwin404\Tecmz\Api\TecmzApi;
use Edwin404\Tecmz\Helpers\ConfigEnvHelper;
use Illuminate\Support\Str;

class TecmzApiUtil
{
    const TecmzApiCaptchaEnable = 'tecmzApiCaptchaEnable';

    /**
     * @return TecmzApi
     */
    private static function instance()
    {
        return TecmzApi::instance(self::appId(), self::appSecret());
    }

    public static function isEnable()
    {
        return ConfigEnvHelper::get('tecmzApiEnable', false);
    }

    public static function appId()
    {
        return ConfigEnvHelper::get('tecmzApiAppId', false);
    }

    public static function appSecret()
    {
        return ConfigEnvHelper::get('tecmzApiAppSecret', false);
    }

    public static function captchaIsEnable()
    {
        if (!self::isEnable()) {
            return false;
        }
        if (!ConfigEnvHelper::get(self::TecmzApiCaptchaEnable, false)) {
            return false;
        }
        return true;
    }

    public static function captchaScript()
    {
        return 'https://api.' . __BASE_SITE__ . '/static/captcha/base-1.0.0.js?20190125';
    }

    public static function captchaControllerVerify()
    {
        $input = InputPackage::buildFromInput();
        return self::instance()->captchaVerify(
            $input->getTrimString('action'),
            $input->getTrimString('key'),
            $input->getTrimString('data'),
            $input->getTrimString('runtime'),
            $input->getTrimString('types')
        );
    }

    public static function captchaValidate($key)
    {
        if (Str::startsWith($key, 'key:')) {
            $key = substr($key, strlen('key:'));
        }
        $ret = self::instance()->captchaValidate($key);
        if (!isset($ret['code'])) {
            return Response::generate(-1, '请求错误（' . json_encode($ret, JSON_UNESCAPED_UNICODE) . '）');
        }
        return $ret;
    }

}
