<?php

namespace Edwin404\Tecmz\Helpers;

use EasyWeChat\Factory;
use EasyWeChat\Foundation\Application;
use Edwin404\Config\Facades\ConfigFacade;
use Edwin404\Tecmz\Wechat\Cache\Cache;
use Edwin404\Wechat\Types\WechatAuthType;

class WechatHelper
{
    public static function oauthMobileApp()
    {
        if (!ConfigFacade::get('oauthWechatMobileEnable')) {
            return null;
        }
        return \Edwin404\Wechat\Helpers\WechatHelper::app(0, [
            'enable' => true,
            'appId' => ConfigFacade::get('oauthWechatMobileAppId', ''),
            'appSecret' => ConfigFacade::get('oauthWechatMobileAppSecret', ''),
            'appToken' => '',
            'appEncodingKey' => '',
            'authType' => WechatAuthType::CONFIG,
        ], ['payment' => false,]);
    }

    public static function oauthWechatMiniProgram()
    {
        if (!ConfigFacade::get('oauthWechatMiniProgramEnable')) {
            return null;
        }
        $config = [
            'app_id' => ConfigEnvHelper::get('oauthWechatMiniProgramAppId'),
            'secret' => ConfigEnvHelper::get('oauthWechatMiniProgramAppSecret'),
            'response_type' => 'array',
            'log' => [
                'level' => 'debug',
                'file' => storage_path('logs/wechat.log'),
            ],
        ];
        $miniProgram = Factory::miniProgram($config);
        $miniProgram['cache'] = new Cache();
        return $miniProgram;
    }

    public static function oauthWechatMiniProgram2()
    {
        if (!ConfigFacade::get('oauthWechatMiniProgram2Enable')) {
            return null;
        }
        $config = [
            'app_id' => ConfigEnvHelper::get('oauthWechatMiniProgram2AppId'),
            'secret' => ConfigEnvHelper::get('oauthWechatMiniProgram2AppSecret'),
            'response_type' => 'array',
            'log' => [
                'level' => 'debug',
                'file' => storage_path('logs/wechat.log'),
            ],
        ];
        $miniProgram = Factory::miniProgram($config);
        $miniProgram['cache'] = new Cache();
        return $miniProgram;
    }

    public static function shareApp()
    {
        if (!ConfigFacade::get('shareWechatMobileEnable')) {
            return null;
        }
        return \Edwin404\Wechat\Helpers\WechatHelper::app(0, [
            'enable' => true,
            'appId' => ConfigFacade::get('shareWechatMobileAppId', ''),
            'appSecret' => ConfigFacade::get('shareWechatMobileAppSecret', ''),
            'appToken' => '',
            'appEncodingKey' => '',
            'authType' => WechatAuthType::CONFIG,
        ], ['payment' => false,]);
    }

    public static function wxApp()
    {
        if (!ConfigFacade::get('wxappEnable')) {
            return null;
        }
        $options = [
            // ...
            'mini_program' => [
                'app_id' => ConfigFacade::get('wxappAppId', ''),
                'secret' => ConfigFacade::get('wxappAppSecret', ''),
                // token 和 aes_key 开启消息推送后可见
                'token' => '',
                'aes_key' => ''
            ],
            // ...
        ];
        return new Application($options);
    }

}