<?php

namespace EdwinFound\Utils;


class FormatUtil
{
    public static function telephone($number)
    {
        $number = str_replace([
            '+86',
            '+',
            ' ',
            '(',
            ')',
            '-',
            '（',
            '）',
            '',
            ' ',
            '　',
            '"',
            ';',
            "\t",
        ], '', $number);
        $number = trim($number);
        if (!preg_match('/^[0-9]{3,20}$/', $number)) {
            return null;
        }
        return $number;
    }

    public static function isPhone($phone)
    {
        return preg_match('/^1[0-9]{10}$/', $phone);
    }

    public static function isUUID($uuid)
    {
        return preg_match('/^[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}$/', $uuid);
    }

    public static function isUrl($url)
    {
        return preg_match('/^(http|https):\\/\\//', $url);
    }
}
