<?php

namespace EdwinFound\Utils;


class TimeUtil
{
    public static function humanTimeLength($timeSeconds)
    {
        $pcs = [];
        if ($timeSeconds >= 24 * 3600) {
            $v = intval($timeSeconds / (24 * 3600));
            $pcs[] = $v . '天';
            $timeSeconds %= (24 * 3600);
        }
        if ($timeSeconds >= 3600) {
            $v = intval($timeSeconds / 3600);
            $pcs[] = $v . '小时';
            $timeSeconds %= 3600;
        }
        if ($timeSeconds >= 60) {
            $v = intval($timeSeconds / 60);
            $pcs[] = $v . '分钟';
            $timeSeconds %= 60;
        }
        if ($timeSeconds > 0) {
            $pcs[] = $timeSeconds . '秒';
        }
        return join('', $pcs);
    }
}