<?php

namespace EdwinFound\Utils;


class TimezoneUtil
{
    private static $TIMEZONE_BASE = 8;

    /**
     * 获取指定时区的时间
     *
     * @param $timezone
     * @param $format
     * @param $time
     * @return string
     */
    public static function date($timezone = +8, $format = 'Y-m-d H:i:s', $time = null)
    {
        if (null === $time) {
            $time = time();
        } else if ($time && is_string($time)) {
            $time = strtotime($time);
        }
        return date($format, $time - (self::$TIMEZONE_BASE - $timezone) * 3600);
    }

    public static function dateRevert($timezone = +8, $format = 'Y-m-d H:i:s', $time = null)
    {
        if (null === $time) {
            $time = time();
        } else if ($time && is_string($time)) {
            $time = strtotime($time);
        }
        return date($format, $time + (self::$TIMEZONE_BASE - $timezone) * 3600);
    }

    public static function dayRange($day, $timezone = +8, $format = 'Y-m-d H:i:s')
    {
        $time = strtotime($day . ' 00:00:00');
        return [
            'start' => TimezoneUtil::dateRevert($timezone, $format, $time),
            'end' => TimezoneUtil::dateRevert($timezone, $format, $time + 3600 * 24 - 1)
        ];
    }

    /*
    timezone	time(timezone)	    calc                date(timezone)	    time(+8)	hour diff
    -12	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/16 1:00	    49	        +49
    -11	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/16 0:00	    48	        +48
    -10	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 23:00	47	        +47
    -9	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 22:00	46	        +46
    -8	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 21:00	45	        +45
    -7	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 20:00	44	        +44
    -6	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 19:00	43	        +43
    -5	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 18:00	42	        +42
    -4	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 17:00	41	        +41
    -3	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 16:00	40	        +40
    -2	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 15:00	39	        +39
    -1	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 14:00	38	        +38
    0	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 13:00	37	        +37
    +1	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 12:00	36	        +36
    +2	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 11:00	35	        +35
    +3	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 10:00	34	        +34
    +4	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 9:00	    33	        +33
    +5	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 8:00	    32	        +32
    +6	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 7:00	    31	        +31
    +7	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 6:00	    30	        +30
    +8	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 5:00	    29	        +29
    +9	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 4:00	    28	        +28
    +10	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 3:00	    27	        +27
    +11	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 2:00	    26	        +26
    +12	        2018/12/15 5:00	    2018/12/14 0:00	    2018/12/15 1:00	    25	        +25
    */
    /**
     * 获取整点所命中的时区
     *
     * @param targetHour
     * @param timestamp
     * @param baseTimezone
     * @return
     */
    public static function calcTimezones($targetHour, $timestamp = null, $baseTimezone = null)
    {
        if (null === $timestamp) {
            $timestamp = time();
        }
        if (null === $baseTimezone) {
            $baseTimezone = self::$TIMEZONE_BASE;
        }
        $timestamp = intval($timestamp / 3600) * 3600;
        $timezones = [];
        $hour = intval(date('H', $timestamp));
        $timezone = $baseTimezone + $targetHour - $hour;
        if ($timezone > 12) {
            $timezone -= 24;
        } else if ($timezone < -12) {
            $timezone += 24;
        }
        $timezones[] = $timezone;
        if ($timezone == 12 || $timezone == -12) {
            $timezones[] = -$timezone;
        }
        return $timezones;
    }


}
