<?php

namespace App\Admin\Controller;

use App\Util\QuickNavUtil;
use TechSoft\Laravel\Admin\Cms\CategoryCms;
use TechSoft\Laravel\Admin\Cms\Field\FieldImage;
use TechSoft\Laravel\Admin\Cms\Field\FieldText;
use TechSoft\Laravel\Admin\Cms\Field\FieldTextarea;
use TechSoft\Laravel\Admin\Support\AdminCheckController;

class QuickNavController extends AdminCheckController
{

    private $cmsConfigData = [
        'model' => 'quick_nav',
        'pageTitle' => '快捷操作',
        'group' => 'data',
        'maxLevel' => 1,
        'canAdd' => true,
        'canEdit' => true,
        'canDelete' => true,
        'canView' => false,
        'canSort' => true,
        'primaryKeyShow' => false,
        'fields' => [
            'name' => ['type' => FieldText::class, 'title' => '名称', 'list' => true, 'add' => true, 'edit' => true, 'view' => true],
            'summary' => ['type' => FieldTextarea::class, 'title' => '说明', 'list' => true, 'add' => true, 'edit' => true, 'view' => true],
            'image' => ['type' => FieldImage::class, 'title' => '图标', 'list' => true, 'add' => true, 'edit' => true, 'view' => true],
            'link' => ['type' => FieldText::class, 'title' => '链接', 'list' => true, 'add' => true, 'edit' => true, 'view' => true],
        ]
    ];

    public function dataPostChange($type, $data)
    {
        QuickNavUtil::clearCache();
    }


    public function dataList(CategoryCms $categoryCms)
    {
        return $categoryCms->executeList($this, $this->cmsConfigData);
    }

    public function dataAdd(CategoryCms $categoryCms)
    {
        return $categoryCms->executeAdd($this, $this->cmsConfigData);
    }

    public function dataEdit(CategoryCms $categoryCms)
    {
        return $categoryCms->executeEdit($this, $this->cmsConfigData);
    }

    public function dataDelete(CategoryCms $categoryCms)
    {
        return $categoryCms->executeDelete($this, $this->cmsConfigData);
    }

    public function dataView(CategoryCms $categoryCms)
    {
        return $categoryCms->executeView($this, $this->cmsConfigData);
    }

    public function dataSort(CategoryCms $categoryCms)
    {
        return $categoryCms->executeSort($this, $this->cmsConfigData);
    }

}