<?php

namespace App\Util;


use EdwinFound\Laravel\Cache\CacheUtil;
use EdwinFound\Laravel\Dao\ModelUtil;
use EdwinFound\Laravel\Util\TreeUtil;

class ArticleCategoryUtil
{
    public static function clearCache()
    {
        CacheUtil::forget('articleCategory');
        CacheUtil::forget('articleCategoryTree');
    }

    public static function all()
    {
        return CacheUtil::remember('articleCategory', 3600, function () {
            return ModelUtil::all('article_category', [], ['*'], ['sort', 'asc']);
        });
    }

    public static function tree()
    {
        return CacheUtil::remember('articleCategoryTree', 3600, function () {
            return TreeUtil::model2Nodes('article_category', ['name']);
        });
    }

    public static function get($id)
    {
                return ModelUtil::get('article_category', $id);
    }
}
