@extends('theme.default.pc.frame')

@section('pageTitle',htmlspecialchars($category['name'].' - '.\TechSoft\Laravel\Config\ConfigUtil::get('siteName')))
@section('pageKeywords',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName').','.$category['name']))
@section('pageDescription',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName').','.$category['name']))

@section('body')

    @include('theme.default.pc.header')

    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            @foreach($chain as $item)
                <a href="/article_list/{{$item['id']}}">{{$item['name']}}</a>
            @endforeach
            <a class="active" href="/article_list/{{$category['id']}}">文档列表</a>
        </div>
    </div>

    <div class="ub-container">
        <div class="ub-container-row">
            <div class="row">
                <div class="col-md-3 col-12">
                    @include('theme.default.pc.inc.articleCategoryTree',['tree'=>$_articleCategoryTree,'id'=>$category['id']])
                </div>
                <div class="col-md-9 col-12">
                    <div class="ub-list">
                        <div class="head">
                            <div class="title">
                                {{$category['name']}}
                            </div>
                        </div>
                        <div class="body">
                            @foreach($articles as $article)
                                <a class="item-c" href="/article/{{$article['id']}}">
                                    <i class="iconfont icon-description1"></i>
                                    {{$article['title']}}
                                </a>
                            @endforeach
                            @if(empty($articles))
                                <div class="ub-empty">暂无记录</div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('theme.default.pc.footer')

@endsection
