@extends('theme.default.pc.frame')

@section('pageTitle',htmlspecialchars($article['title'].' - '.\TechSoft\Laravel\Config\ConfigUtil::get('siteName')))
@section('pageKeywords',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName').','.$article['title']))
@section('pageDescription',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName').','.$article['title']))

@section('body')

    @include('theme.default.pc.header')

    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            @foreach($chain as $item)
                <a href="/article_list/{{$item['id']}}">{{$item['name']}}</a>
            @endforeach
            <a class="active" href="/article/{{$article['id']}}">{{$article['title']}}</a>
        </div>
    </div>

    <div class="ub-container">
        <div class="ub-container-row">
            <div class="row">
                <div class="col-md-3 col-12">
                    @include('theme.default.pc.inc.articleCategoryTree',['tree'=>$_articleCategoryTree,'id'=>$article['categoryId']])
                </div>
                <div class="col-md-9 col-12">
                    <div class="ub-article" style="background:#FFF;padding:20px;">
                        <h1 class="ub-text-center">{{$article['title']}}</h1>
                        <div class="attr">
                            最后更新：{{$article['updated_at']}}
                        </div>
                        <div class="content ub-html">
                            {!! $article['content'] !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('theme.default.pc.footer')

@endsection
