@extends('theme.default.pc.frame')

@section('pageTitle',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName').' - '.\TechSoft\Laravel\Config\ConfigUtil::get('siteSlogan')))
@section('pageKeywords',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteKeywords')))
@section('pageDescription',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteDescription')))

@section('body')

    @include('theme.default.pc.header')

    @include('theme.default.pc.inc.searchBlock')

    <div class="ub-container margin-top">
        <div class="ub-list">
            <div class="head">
                <div class="title">
                    快速导航
                </div>
            </div>
            <div class="body">
                <div class="row">
                    @foreach($quickNav as $item)
                        <div class="col-md-3 col-12">
                            <div class="item-a">
                                <a class="icon" href="{{$item['link']}}">
                                    <img src="{{$item['image']}}"/>
                                </a>
                                <a class="title" href="{{$item['link']}}">{{$item['name']}}</a>
                                <div class="summary">
                                    {{$item['summary']}}
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <div class="ub-container margin-top">
        <div class="ub-container-row">
            <div class="row">
                @foreach($_articleCategoryTree as $group)
                    <div class="col-md-4 col-12 margin-bottom">
                        <div class="ub-list j-article-category-item" >
                            <div class="head">
                                <div class="title">
                                    {{$group['name']}}
                                </div>
                            </div>
                            <div class="body">
                                <div class="row">
                                    @foreach($group['_child'] as $item)
                                        <div class="col-md-6 col-12">
                                            <a class="item-b" href="/article_list/{{$item['id']}}">{{$item['name']}}</a>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <script>
        $(function () {
           var max = 0
           $('.j-article-category-item').each(function (i,o) {
               max = Math.max(max,$(o).height());
           }).css('height',max+'px');
        });
    </script>

    @include('theme.default.pc.footer')

@endsection
