@extends('theme.default.pc.frame')

@section('pageTitle',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName').' - '.\TechSoft\Laravel\Config\ConfigUtil::get('siteSlogan')))
@section('pageKeywords',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteKeywords')))
@section('pageDescription',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteDescription')))

@section('body')

    @include('theme.default.pc.header')

    @include('theme.default.pc.inc.searchBlock')

    <div class="ub-container margin-top">
        <div class="ub-search-result">
            搜索 <span class="keyword">{{$keyword}}</span> ，共找到 <span class="count">{{$total}}</span> 条记录
        </div>
    </div>

    <div class="ub-container margin-top">
        <div class="ub-list">
            <div class="head">
                <div class="title">
                    搜索结果
                </div>
            </div>
            <div class="body">
                @if(empty($records))
                    <div class="ub-empty">
                        没有找到记录
                    </div>
                @endif
                <div class="row">
                    @foreach($records as $record)
                        <div class="col-md-12 col-12">
                            <div class="item-d">
                                <a class="title" href="/article/{{$record['id']}}">{{$record['title']}}</a>
                                <div class="attr">
                                    分类：
                                    <a href="/article_list/{{$record['categoryId']}}">{{$record['_category']['name']}}</a>
                                </div>
                                <div class="summary">
                                    {{\TechSoft\Laravel\Util\HtmlUtil::text($record['content'],200)}}
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <div class="ub-container">
        <div class="ub-page">
            {!! $pageHtml !!}
        </div>
    </div>

    @include('theme.default.pc.footer')

    <style>
        [data-markjs]{color:red !important;background:transparent;}
    </style>
    <script>
        $('.item-d .title').mark({!! json_encode($keyword) !!},{});
    </script>

@endsection
