<?php

namespace TechSoft\Laravel\Sms;

use EdwinFound\Laravel\Exception\TodoException;
use TechSoft\Laravel\Config\ConfigUtil;
use TechSoft\Laravel\Sms\Service\AliyunSmsService;

class SmsUtil
{
    public static function send($phone, $type, $templateData = [])
    {
        if (!ConfigUtil::get('systemSmsEnable')) {
            return Response::generate(-1, '短信发送未开启');
        }

        $senderParam = [];

        $senderFunc = ConfigUtil::get('systemSmsSender') . 'Execute';
        return self::$senderFunc($phone, $type, $templateData);
    }

    private static function commonExecute($phone, $type, $templateData = [])
    {
        TodoException::throws();
    }

    private static function aliyunExecute($phone, $type, $templateData = [])
    {
        $senderParam = [];
        switch ($type) {
            case SmsTemplate::VERIFY:
                $senderParam['code'] = $templateData['code'];
                break;
        }
        $driver = new AliyunSmsService(
            ConfigUtil::get('systemSmsSender_aliyun_accessKeyId'),
            ConfigUtil::get('systemSmsSender_aliyun_accessKeySecret'),
            ConfigUtil::get('systemSmsSender_aliyun_signName')
        );
        return $driver->send($phone, ConfigUtil::get('systemSmsSender_aliyun_verify_templateId'), $senderParam);
    }

}