<?php
/*
文章列表区块
参数1：文章数，默认10，可用参数：大于0整数
参数2：排序字段，默认aid，可用参数：aid（文章序号），views（浏览数），favs（收藏数），tops（顶赞数），downs（下载数），addtime（发布时间）
参数3：分类ID，默认0，可用参数：0（全部文章），分类ID，cid（系统取$_REQUEST['cid']值），$cid（系统取已定义模版变量cid值）
参数4：文章类型，默认all，可用参数：all（全部文章），article（单文章），chapter（多章节文章），slide（图集文章）
参数5：是否有标题图片，默认0，可用参数：0（全部文章），1（有标题图片文章）
参数6：推荐级别，默认0，可用参数：0（全部文章），1-9（推荐级别）
参数7：专题ID，默认0，可用参数：0（全部文章），专题ID，topicid（系统取$_REQUEST['topicid']值），$topicid（系统取已定义模版变量topicid值）
参数8：会员ID，默认0，可用参数：0（全部文章），会员ID，uid（系统取$_REQUEST['uid']值），$uid（系统取已定义模版变量uid值）
*/
class blockarticlelist extends saxueblock {
		public $template = "block_articlelist.html";
		public $exevars = array( 'listnum' => 10, 'field' => 'aid', 'cid' => '0', 'type' => 'all', 'isthumb' => '0', 'level' => '0', 'topicid' => '0', 'uid' => '0' );
		public function blockarticlelist( &$_vars ) {
				global $saxueTpl;
				$this -> saxueblock( $_vars );
				if ( !empty( $this -> blockvars['vars'] ) ) {
						$_fieldarr = explode( ",", trim( $this -> blockvars['vars'] ) );
						$_fieldcount = count( $_fieldarr );
						if ( 0 < $_fieldcount ) {
								$_fieldarr[0] = trim( $_fieldarr[0] );
								if ( is_numeric( $_fieldarr[0] ) && 0 < $_fieldarr[0] ) {
										$this -> exevars['listnum'] = intval( $_fieldarr[0] );
								} 
						}  
						if ( 1 < $_fieldcount ) {
								$_fieldarr[1] = trim( $_fieldarr[1] );
								if ( in_array( $_fieldarr[1], array( "aid", "views", "favs", "tops", "downs", "addtime" ) ) ) {
										$this -> exevars['field'] = $_fieldarr[1];
								} 
						} 
						if ( 2 < $_fieldcount ) {
								$_fieldarr[2] = trim( $_fieldarr[2] );
								if ( is_numeric( $_fieldarr[2] ) ) {
										$this -> exevars['cid'] = $_fieldarr[2];
								} else if ( substr( $_fieldarr[2], 0, 1 ) == "\$" ) {
										$_cidvar = $saxueTpl -> get_assign( substr( $_fieldarr[2], 1 ) );
										if ( is_numeric( $_cidvar ) ) {
												$this -> exevars['cid'] = $_cidvar;
										} 
								} else if ( isset( $_REQUEST[$_fieldarr[2]] ) && is_numeric( $_REQUEST[$_fieldarr[2]] ) ) {
										$this -> exevars['cid'] = $_REQUEST[$_fieldarr[2]];
								}
						} 
						if ( 3 < $_fieldcount ) {
								$_fieldarr[3] = trim( $_fieldarr[3] );
								if ( in_array( $_fieldarr[3], array( "all", "article", "chapter", "slide" ) ) ) {
										$this -> exevars['type'] = $_fieldarr[3];
								} 
						} 
						if ( 4 < $_fieldcount ) {
								$_fieldarr[4] = trim( $_fieldarr[4] );
								if ( is_numeric( $_fieldarr[4] ) && in_array( $_fieldarr[4], array( 0, 1 ) ) ) {
										$this -> exevars['isthumb'] = intval( $_fieldarr[4] );
								} 
						} 
						if ( 5 < $_fieldcount ) {
								$_fieldarr[5] = trim( $_fieldarr[5] );
								if ( is_numeric( $_fieldarr[5] ) && $_fieldarr[5] < 10 && $_fieldarr[5] > 0 ) {
										$this -> exevars['level'] = intval( $_fieldarr[5] );
								} 
						}
						if ( 6 < $_fieldcount ) {
								$_fieldarr[6] = trim( $_fieldarr[6] );
								if ( is_numeric( $_fieldarr[6] ) && 0 < $_fieldarr[6] ) {
										$this -> exevars['topicid'] = intval( $_fieldarr[6] );
								} else if ( substr( $_fieldarr[6], 0, 1 ) == "\$" ) {
										$_topicidvar = $saxueTpl -> get_assign( substr( $_fieldarr[6], 1 ) );
										if ( is_numeric( $_topicidvar ) ) {
												$this -> exevars['topicid'] = $_topicidvar;
										} 
								} else if ( isset( $_REQUEST[$_fieldarr[6]] ) && is_numeric( $_REQUEST[$_fieldarr[6]] ) ) {
										$this -> exevars['topicid'] = $_REQUEST[$_fieldarr[6]];
								} 
						} 
						if ( 7 < $_fieldcount ) {
								$_fieldarr[7] = trim( $_fieldarr[7] );
								if ( is_numeric( $_fieldarr[7] ) && 0 < $_fieldarr[7] ) {
										$this -> exevars['uid'] = intval( $_fieldarr[7] );
								} else if ( substr( $_fieldarr[7], 0, 1 ) == "\$" ) {
										$_uidvar = $saxueTpl -> get_assign( substr( $_fieldarr[7], 1 ) );
										if ( is_numeric( $_uidvar ) ) {
												$this -> exevars['uid'] = $_uidvar;
										} 
								} else if ( isset( $_REQUEST[$_fieldarr[7]] ) && is_numeric( $_REQUEST[$_fieldarr[7]] ) ) {
										$this -> exevars['uid'] = $_REQUEST[$_fieldarr[7]];
								} 
						} 
				} 
				$this -> blockvars['cacheid'] = md5( serialize( $this -> exevars ) . "|" . $this -> blockvars['template'] );
		} 
		public function setcontent( $isreturn = false ) {
				global $saxueTpl;
				global $saxueCate;
				global $article_handler;
				if ( !isset( $saxueCate['article'] ) ) {
						saxue_getconfigs( "cate", 'article' );
				}
				if ( !is_object( $article_handler ) ) {
						include_once SAXUE_ROOT_PATH . "/model/article.php";
						$article_handler = &saxuearticlehandler :: getinstance( "saxuearticlehandler" );
				}
				$where = array();
				if ( !empty( $this -> exevars['uid'] ) ) {
						$where[] = 'uid=' . $this -> exevars['uid'];
				} 
				if ( !empty( $this -> exevars['level'] ) ) {
						$where[] = 'level=' . $this -> exevars['level'];
				} 
				if ( !empty( $this -> exevars['cid'] ) ) {
						$cid = $this -> exevars['cid'];
						if ( $saxueCate['article'][$cid]['child'] ) {
								$where[] = 'pid=' . $cid;
						} else {
								$where[] = 'cid=' . $cid;
						} 
				}
				switch ( $this -> exevars['type'] ) {
						case 'article':
								$where[] = 'ischapter=0';
								break;
						case 'slide':
								$where[] = 'isslide>0';
								break;
						case 'chapter':
								$where[] = 'ischapter=1';
								break;
				}
				if ( !empty( $this -> exevars['topicid'] ) ) {
						$where[] = 'topicid=' . $this -> exevars['topicid'];
				} 
				if ( !empty( $this -> exevars['isthumb'] ) ) {
						$where[] = 'isthumb=1';
				} 
				$where[] = 'status=1';
				$sql = 'SELECT * FROM ' . saxue_dbprefix( "article" ) . ' WHERE ' . implode( ' AND ', $where ) . ' ORDER BY ' . $this -> exevars['field'] . ' DESC LIMIT 0, ' . $this -> exevars['listnum'];
				$res = $article_handler -> db -> query( $sql );
				$rows = $tables = array();
				while ( $v = $article_handler -> getobject( $res ) ) {
						$k = $v -> getvar( 'aid' );
						$rows[$k] = $v -> getvars( 'n' );
						$rows[$k]['cname'] = $saxueCate['article'][$rows[$k]['cid']]['cname'];
						$rows[$k]['curl'] = $saxueCate['article'][$rows[$k]['cid']]['curl'];
						$rows[$k]['scurl'] = $saxueCate['article'][$rows[$k]['cid']]['scurl'];
						if ( $rows[$k]['uid'] > 0 ) {
								$rows[$k]['uhome'] = saxue_geturl( "user_home", $rows[$k]['uid'] );
								$rows[$k]['uavatar'] = saxue_geturl( "user_avatar", $rows[$k]['uid'] );
						}
						$tables[$rows[$k]['tbnum']][] = $k;
				} 
				if ( count( $tables ) > 0 ) {
						foreach ( $tables as $tbnum => $ids  ) {
								$_res = $article_handler -> db -> query( "SELECT * FROM " . saxue_dbprefix( 'article_data_' . $tbnum ) . " WHERE aid IN (" . implode( ',', $ids ) . ")" );
								while ( $v = $article_handler -> getobject( $_res ) ) {
										$k = $v -> getvar( 'aid' );
										$rows[$k] = $rows[$k] + ( $v -> getvars( 'n' ) );
										$rows[$k]['intro'] = nl2br( $rows[$k]['intro'] );
										if ( $rows[$k]['isslide'] ) {
												$rows[$k]['album'] = explode( '|', $rows[$k]['album'] );
										}
										// 读取TAG
										$_tags = array();
										$_tagnum = 0;
										if ( strlen( $rows[$k]['tags'] ) > 0 ) {
												$_arr = explode( ',', $rows[$k]['tags'] );
												$_arrid = explode( ',', $rows[$k]['tagids'] );
												foreach ( $_arr as $_i => $_s ) {
														$_tags[$_tagnum]['name'] = $_s;
														$_tags[$_tagnum]['url'] = saxue_geturl( "tag_show", $_arrid[$_i] );
														++$_tagnum;
												} 
										}
										$rows[$k]['taglist'] = $_tags;
								} 
						} 
				}
				if ( $isreturn ) {
						return $rows;
				}
				$saxueTpl -> assign_by_ref( "rows", $rows );
		} 
} 
