<?php 
// 文章列表
function saxue_url_article_list( $_cid, $_category, $_page = '' ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['article'] ) ) {
				saxue_getconfigs( 'configs', 'article' );
		} 
		switch ( $saxueConfigs['article']['url_list'] ) {
				case 1 :
						if ( $_category[$_cid]['pid'] > 0 ) {
								$url = '/' . $_category[$_category[$_cid]['pid']]['alias'] . '/' . $_category[$_cid]['alias'] . '/';
						} else {
								$url = '/' . $_category[$_cid]['alias'] . '/';
						}
						if ( !empty( $_page ) ) {
								$url .= $_page . '/';
						}
						return $url;
				case 2 :
						if ( !empty( $_page ) ) return '/article/c' . $_cid . '_p' . $_page . '.html';
						return '/article/c' . $_cid . '_p1.html';
				case 3 :
						if ( $_category[$_cid]['pid'] > 0 ) {
								$url = '/article/list' . $_category[$_cid]['pid'] . '/list' . $_cid . '/';
						} else {
								$url = '/article/list' . $_cid . '/';
						}
						if ( !empty( $_page ) ) {
								$url .= $_page . '.html';
						}
						return $url;
				case 0 :
				default :
						if ( !empty( $_page ) ) return '/article/list.php?cid=' . $_cid . '&page=' . $_page;
						return '/article/list.php?cid=' . $_cid;
		}
} 
// 文章显示
function saxue_url_article_show( $_aid, $_cid = 0, $_addtime = 0, $_ischapter = 0 ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['article'] ) ) {
				saxue_getconfigs( 'configs', 'article' );
		} 
		$_postfix = $_ischapter ? '/' : '.html';
		switch ( $saxueConfigs['article']['url_detail'] ) {
				case 1 :
						return '/article/' . $_aid . $_postfix;
				case 2 :
						global $saxueCate;
						if ( !isset( $saxueCate['article'] ) ) {
								saxue_getconfigs( 'cate', 'article' );
						} 
						if ( $saxueCate['article'][$_cid]['pid'] ) {
								return '/' . $saxueCate['article'][$saxueCate['article'][$_cid]['pid']]['alias'] . '/' . $saxueCate['article'][$_cid]['alias'] . '/' . $_aid . $_postfix;
						}
						return '/' . $saxueCate['article'][$_cid]['alias'] . '/' . $_aid . $_postfix;
				case 3 :
						return $saxueConfigs['article']['htmlurl'] . saxue_getsubdir( $_aid ) . '/' . $_aid . $_postfix;
				case 4 :
						return $saxueConfigs['article']['htmlurl'] . '/' . date( 'Y', $_addtime ) . '/' . date( 'md', $_addtime ) . '/' . $_aid . $_postfix;
				case 0 :
				default :
						return '/article/detail.php?aid=' . $_aid;
		}
}
// 图集列表
function saxue_url_slide_list( $_cid, $_category, $_page = '' ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['article'] ) ) {
				saxue_getconfigs( 'configs', 'article' );
		} 
		switch ( $saxueConfigs['article']['url_list'] ) {
				case 1 :
						if ( $_category[$_cid]['pid'] > 0 ) {
								$url = '/slide/' . $_category[$_category[$_cid]['pid']]['alias'] . '/' . $_category[$_cid]['alias'] . '/';
						} else {
								$url = '/slide/' . $_category[$_cid]['alias'] . '/';
						}
						if ( !empty( $_page ) ) {
								$url .= $_page . '/';
						}
						return $url;
				case 2 :
						if ( !empty( $_page ) ) return '/slide/c' . $_cid . '_p' . $_page . '.html';
						return '/slide/c' . $_cid . '_p1.html';
				case 3 :
						if ( $_category[$_cid]['pid'] > 0 ) {
								$url = '/slide/list' . $_category[$_cid]['pid'] . '/list' . $_cid . '/';
						} else {
								$url = '/slide/list' . $_cid . '/';
						}
						if ( !empty( $_page ) ) {
								$url .= $_page . '.html';
						}
						return $url;
				case 0 :
				default :
						if ( !empty( $_page ) ) return '/slide/list.php?cid=' . $_cid . '&page=' . $_page;
						return '/slide/list.php?cid=' . $_cid;
		}
} 
// 文章图集
function saxue_url_slide_show( $_aid, $_cid = 0, $_addtime = 0, $_isslide = 0 ) {
		if ( !$_isslide ) {
				return '';
		}
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['article'] ) ) {
				saxue_getconfigs( 'configs', 'article' );
		} 
		switch ( $saxueConfigs['article']['url_detail'] ) {
				case 1 :
						return '/slide/' . $_aid . '.html';
				case 2 :
						global $saxueCate;
						if ( !isset( $saxueCate['article'] ) ) {
								saxue_getconfigs( 'cate', 'article' );
						} 
						if ( $saxueCate['article'][$_cid]['pid'] ) {
								return '/slide/' . $saxueCate['article'][$saxueCate['article'][$_cid]['pid']]['alias'] . '/' . $saxueCate['article'][$_cid]['alias'] . '/' . $_aid . '.html';
						}
						return '/slide/' . $saxueCate['article'][$_cid]['alias'] . '/' . $_aid . '.html';
				case 3 :
						return $saxueConfigs['article']['htmlurl'] . saxue_getsubdir( $_aid ) . '/slide_' . $_aid . '.html';
				case 4 :
						return $saxueConfigs['article']['htmlurl'] . '/' . date( 'Y', $_addtime ) . '/' . date( 'md', $_addtime ) . '/slide_' . $_aid . '.html';
				case 0 :
				default :
						return '/slide/detail.php?aid=' . $_aid;
		}
}
// 文章内容分页
function saxue_url_article_page( $_aid = 0, $_page = 0 ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['article'] ) ) {
				saxue_getconfigs( 'configs', 'article' );
		} 
		if ( !$saxueConfigs['article']['url_detail'] ) return 'detail.php?aid=' . $_aid . '&page=' . $_page;
		if ( $_page ) return $_aid . '-' . $_page . '.html';
		return $_aid . '.html';
		
}
// 文章章节页
function saxue_url_article_chapter( $_chapterid = 0, $_aid = 0 ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['article'] ) ) {
				saxue_getconfigs( 'configs', 'article' );
		} 
		if ( !$saxueConfigs['article']['url_detail'] ) return 'detail.php?aid=' . $_aid . '&chapterid=' . $_chapterid;
		if ( $_chapterid ) return $_chapterid . '.html';
		return 'index.html';
		
}
// TAG列表
function saxue_url_tag_list( $_cid, $_page = '' ) {
		global $saxueConfigs;
		global $saxueCate;
		if ( !isset( $saxueConfigs['tag'] ) ) {
				saxue_getconfigs( 'configs', 'tag' );
		} 
		if ( !isset( $saxueCate['article'] ) ) {
				saxue_getconfigs( 'cate', 'article' );
		} 
		switch ( $saxueConfigs['tag']['url_list'] ) {
				case 1 :
						$url = '/tags/';
						if ( $_cid ) {
								if ( $saxueCate['article'][$_cid]['pid'] ) {
										$url .= $saxueCate['article'][$saxueCate['article'][$_cid]['pid']]['alias'] . '_' . $saxueCate['article'][$_cid]['alias'] . '/';
								} else {
										$url .= $saxueCate['article'][$_cid]['alias'] . '/';
								}
						}
						if ( !empty( $_page ) ) $url .= $_page . '/';
						return $url;
				case 2 :
						$url = '/tags/';
						if ( $_cid ) {
								if ( $saxueCate['article'][$_cid]['pid'] ) {
										$url .= $saxueCate['article'][$saxueCate['article'][$_cid]['pid']]['alias'] . '_' . $saxueCate['article'][$_cid]['alias'];
								} else {
										$url .= $saxueCate['article'][$_cid]['alias'];
								}
						}
						if ( !empty( $_page ) ) {
								if ( $_cid ) {
										$url .= '-';
								}
								$url .= $_page . '.html';
						}
						return $url;
				case 0 :
				default :
						$url = '/tag/list.php';
						if ( !empty( $_cid ) && !empty( $_page ) ) $url .= '?cid=' . $_cid . '&page=' . $_page;
						elseif ( !empty( $_cid ) ) $url .= '?cid=' . $_cid;
						elseif ( !empty( $_page ) ) $url .= '?page=' . $_page;
						return $url;
		}
}
// TAG显示
function saxue_url_tag_show( $_tagid, $_page = '' ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['tag'] ) ) {
				saxue_getconfigs( 'configs', 'tag' );
		} 
		switch ( $saxueConfigs['tag']['url_detail'] ) {
				case 1 :
						if ( !empty( $_page ) ) return '/tag/' . $_tagid . '/' . $_page . '/';
						return '/tag/' . $_tagid . '/';
				case 0 :
				default :
						if ( !empty( $_page ) ) return '/tag/detail.php?tagid=' . $_tagid . '&page=' . $_page;
						return '/tag/detail.php?tagid=' . $_tagid;
		}
}
// 专题列表
function saxue_url_topic_list( $_cid, $_alias, $_page = '' ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['topic'] ) ) {
				saxue_getconfigs( 'configs', 'topic' );
		} 
		switch ( $saxueConfigs['topic']['url_list'] ) {
				case 1 :
						if ( !empty( $_page ) ) return '/zt/' . $_alias . '/' . $_page . '/';
						return '/zt/' . $_alias . '/';
				case 2 :
						if ( !empty( $_page ) ) return '/zt/' . $_alias . '-' . $_page . '.html';
						return '/zt/' . $_alias . '.html';
				case 0 :
				default :
						if ( !empty( $_page ) ) return '/topic/list.php?cid=' . $_cid . '&page=' . $_page;
						return '/topic/list.php?cid=' . $_cid;
		}
} 
// 专题显示
function saxue_url_topic_show( $_topicid, $_cid = 0, $_alias = '' ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['topic'] ) ) {
				saxue_getconfigs( 'configs', 'topic' );
		} 
		global $saxueCate;
		if ( !isset( $saxueCate['topic'] ) ) {
				saxue_getconfigs( 'cate', 'topic' );
		} 
		switch ( $saxueConfigs['topic']['url_detail'] ) {
				case 1 :
						return '/zt/' . $_topicid . '.html';
				case 2 :
						return '/zt/' . $saxueCate['topic'][$_cid]['alias'] . '/' . $_topicid . '.html';
				case 3 :
						return $saxueConfigs['topic']['htmlurl'] . saxue_getsubdir( $_topicid ) . '/' . $_topicid . '.html';
				case 4 :
						if ( empty( $_alias ) ) return $saxueConfigs['topic']['htmlurl'] . '/' . $saxueCate['topic'][$_cid]['alias'] . '/' . $_topicid . '/';
						return $saxueConfigs['topic']['htmlurl'] . '/' . $saxueCate['topic'][$_cid]['alias'] . '/' . $_alias . '/';
				case 0 :
				default :
						return '/topic/detail.php?topicid=' . $_topicid;
		}
}
// 专题文章分页
function saxue_url_topic_page( $_topicid, $_page = 1 ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['topic'] ) ) {
				saxue_getconfigs( 'configs', 'topic' );
		} 
		switch ( $saxueConfigs['topic']['url_detail'] ) {
				case 1 :
						if ( $_page > 1 ) return $_topicid . '-' . $_page . '.html';
						return $_topicid . '.html';
				case 2 :
						if ( $_page > 1 ) return $_topicid . '-' . $_page . '.html';
						return $_topicid . '.html';
				case 3 :
						if ( $_page > 1 ) return $_topicid . '-' . $_page . '.html';
						return $_topicid . '.html';
				case 4 :
						if ( $_page > 1 ) return $_page . '.html';
						return 'index.html';
				case 0 :
				default :
						if ( $_page > 1 ) return 'detail.php?topicid=' . $_topicid . '&page=' . $_page;
						return 'detail.php?topicid=' . $_topicid;
		}
		
}
// 会员个人主页
function saxue_url_user_home( $_uid = 0, $_type = '', $_page = '' ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['member'] ) ) {
				saxue_getconfigs( "configs", "member" );
		} 
		switch ( $saxueConfigs['member']['url_home'] ) {
				case 1 :
						$url = '/u/' . $_uid . '/';
						if ( !empty( $_type ) ) {
								$url .= $_type . '/';
						}
						if ( !empty( $_page ) ) $url .= $_page . '/';
						break;
				case 0 :
				default :
						$url = '/space/';
						if ( empty( $_type ) ) {
								$_type = 'home';
						}
						$tmp = explode( '-', $_type );
						$url .= $tmp[0] . '.php?uid=' . $_uid;
						if ( isset( $tmp[1] ) ) $url .= '&' . $tmp[0] . '=' . $tmp[1];
						if ( !empty( $_page ) ) $url .= '&page=' . $_page;
						break;
		}
		return $url;
} 
// 会员头像
function saxue_url_user_avatar( $_uid, $_size = "s", $_type = 2 ) {
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['member'] ) ) {
				saxue_getconfigs( "configs", "member" );
		} 
		$_avatar_url = "";
		if ( $_uid == 0 ) {
				$_uid = "avatar";
				$_avatar_url = SAXUE_SKIN_URL . "/images/member";
		} else {
				switch ( $_type ) {
						case 0:
								$_uid = 'avatar';
								$_avatar_url = SAXUE_SKIN_URL . "/images/member";
								break;
						case 1:
								$_avatar_url = saxue_uploadurl( 'avatar' ) . saxue_getsubdir( $_uid );
								break;
						case 2:
								$_avatar_path = saxue_uploadpath( 'avatar' ) . saxue_getsubdir( $_uid );
								if ( file_exists( $_avatar_path . '/' . $_uid . ".jpg" ) ) {
										$_avatar_url = saxue_uploadurl( 'avatar' ) . saxue_getsubdir( $_uid );
								} else {
										$_uid = "avatar";
										$_avatar_url = SAXUE_SKIN_URL . "/images/member";
								}
								break;
				}
		}
		switch ( $_size ) {
				case "d" :
						return $_avatar_url;
				case "l" :
						return $_avatar_url . "/" . $_uid . ".jpg";
				case "s" :
						return $_avatar_url . "/" . $_uid . "s.jpg";
				case "i" :
						return $_avatar_url . "/" . $_uid . "i.jpg";
				case "a" :
				default:
						return array( "l" => $_avatar_url . "/" . $_uid . ".jpg", "s" => $_avatar_url . "/" . $_uid . "s.jpg" . $_prefix, "i" => $_avatar_url . "/" . $_uid . "i.jpg" . $_prefix, "d" => $_avatar_url );
		} 
}
