<?php
if ( !isset( $saxueConfigs['topic'] ) ) {
		saxue_getconfigs( "configs", "topic" );
}
class saxuepacktopic extends saxueobject {
		public $topicid = 0;
		public $row = array();
		public $isload = false;

		public function saxuepacktopic( $_vars ) {
				$this -> saxueobject();
				if ( is_array( $_vars ) ) {
						$this -> topicid = intval( $_vars['topicid'] );
						$this -> row = $_vars;
						$this -> isload = true;
				} else {
						$this -> topicid = intval( $_vars );
						$this -> isload = false;
				}
		} 

		public function setid( $_topicid = 0 ) {
				$this -> topicid = intval( $_topicid );
		} 

		public function getid() {
				return $this -> topicid;
		} 

		public function gettemplate() {
				$_template = SAXUE_THEME_PATH . '/topic/' . $this -> row['temp'];
				if ( !is_file( $_template ) ) {
						$_template = SAXUE_THEME_PATH . '/topic/detail.html';
				}
				return $_template;
		} 

		public function loadtopic() {
				if ( $this -> topicid <= 0 ) {
						return false;
				}
				global $topic_handler;
				if ( !is_object( $topic_handler ) ) {
						include_once( SAXUE_ROOT_PATH . "/model/topic.php" );
						$topic_handler = saxuetopichandler :: getinstance( "saxuetopichandler" );
				}
				// 主表
				$_topic = $topic_handler -> get( $this -> topicid );
				if ( !is_object( $_topic ) || $_topic -> getvar( 'status' ) != 1 ) {
						return false;
				} 
				$_row = $_topic -> getvars( 'n' );
				// 数据表
				global $topicdata_handler;
				if ( !is_object( $topicdata_handler ) ) {
						include_once SAXUE_ROOT_PATH . "/model/topic_data.php";
						$topicdata_handler = saxuetopicdatahandler :: getinstance( "saxuetopicdatahandler" );
				}
				$_data = $topicdata_handler -> get( $this -> topicid );
				if ( !is_object( $_data ) ) {
						return false;
				} 
				$_row = $_row + ( $_data -> getvars( 'n' ) );
				$this -> row = $_row;
				$this -> isload = true;
				return true;
		} 

		public function loadarticle( $_pagesize, $_page = 1 ) {
				$rows = array();
				if ( $this -> topicid <= 0 ) {
						return $rows;
				}
				global $saxueConfigs;
				global $article_handler;
				global $saxueCate;
				if ( !isset( $saxueCate['article'] ) ) {
						saxue_getconfigs( "cate", "article" );
				} 
				if ( !isset( $saxueConfigs['article'] ) ) {
						saxue_getconfigs( 'configs', 'article' );
				} 
				if ( !is_object( $article_handler ) ) {
						include SAXUE_ROOT_PATH . "/model/article.php";
						$article_handler = saxuearticlehandler :: getinstance( "saxuearticlehandler" );
				}
				$criteria = new criteriacompo( new criteria( 'topicid', $this -> topicid ) );
				$criteria -> add( new criteria( 'status', 1 ) );
				$criteria -> setsort( "aid" );
				$criteria -> setorder( "DESC" );
				if ( !empty( $_pagesize ) ) {
						$criteria -> setlimit( $_pagesize );
						$criteria -> setstart( ( $_page - 1 ) * $_pagesize );
				}
				$article_handler -> queryobjects( $criteria );
				$tables = array();
				while ( $v = $article_handler -> getobject() ) {
						$k = $v -> getvar( 'aid' );
						$rows[$k] = $v -> getvars( 'n' );
						$rows[$k]['cname'] = $saxueCate['article'][$rows[$k]['cid']]['cname'];
						$rows[$k]['curl'] = $saxueCate['article'][$rows[$k]['cid']]['curl'];
						if ( $rows[$k]['uid'] > 0 ) {
								$rows[$k]['uhome'] = saxue_geturl( "user_home", $rows[$k]['uid'] );
								$rows[$k]['uavatar'] = saxue_geturl( "user_avatar", $rows[$k]['uid'] );
						}
						$tables[$rows[$k]['tbnum']][] = $k;
				} 
				foreach ( $tables as $tbnum => $ids  ) {
						$_res = $article_handler -> db -> query( "SELECT * FROM " . saxue_dbprefix( 'article_data_' . $tbnum ) . " WHERE aid IN (" . implode( ',', $ids ) . ")" );
						while ( $v = $article_handler -> getobject( $_res ) ) {
								$k = $v -> getvar( 'aid' );
								$rows[$k] = $rows[$k] + ( $v -> getvars( 'n' ) );
								$rows[$k]['intro'] = nl2br( $rows[$k]['intro'] );
								if ( $rows[$k]['isslide'] ) {
										$rows[$k]['album'] = explode( '|', $rows[$k]['album'] );
								}
								// 读取TAG
								$_tags = array();
								$_tagnum = 0;
								if ( strlen( $rows[$k]['tags'] ) > 0 ) {
										$_arr = explode( ',', $rows[$k]['tags'] );
										$_arrid = explode( ',', $rows[$k]['tagids'] );
										foreach ( $_arr as $_i => $_s ) {
												$_tags[$_tagnum]['name'] = $_s;
												$_tags[$_tagnum]['url'] = saxue_geturl( "tag_show", $_arrid[$_i] );
												++$_tagnum;
										} 
								}
								$rows[$k]['taglist'] = $_tags;
						} 
				}
				return $rows;
		} 

		public function showtopic( $_page = 1 ) {
				if ( !$this -> isload ) {
						$this -> loadtopic();
				}
				$this -> makehtml( $_page, true );
		}

		public function maketopic( $_check = false ) {
				if ( !$this -> isload ) {
						$this -> loadtopic();
				}
				if ( $_check && $this -> row['status'] != 1 ) {
						return false;
				}
				return $this -> makehtml( 0, false );
		}

		public function makehtml( $_page, $_show = false ) {
				if ( $this -> topicid <= 0 ) {
						return false;
				}
				global $saxueTpl;
				global $saxueCate;
				global $saxueConfigs;
				global $article_handler;
				if ( !is_object( $saxueTpl ) ) {
						include SAXUE_ROOT_PATH . "/lib/template/template.php";
						$saxueTpl = &saxuetpl :: getinstance();
				}  
				if ( !is_object( $article_handler ) ) {
						include SAXUE_ROOT_PATH . "/model/article.php";
						$article_handler = saxuearticlehandler :: getinstance( "saxuearticlehandler" );
				}
				if ( !isset( $saxueCate['topic'] ) ) {
						saxue_getconfigs( "cate", "topic" );
				}
				// 基础数据
				$this -> row['cname'] = $saxueCate['topic'][$this -> row['cid']]['cname'];
				$this -> row['curl'] = $saxueCate['topic'][$this -> row['cid']]['curl'];
				$saxueTpl -> assign_by_ref( "row", $this -> row );
				// 扩展信息
				$_REQUEST['cid'] = $this -> row['cid']; 
				$saxueTpl -> assign( "cid", $this -> row['cid'] );
				$saxueTpl -> assign( "cname", $this -> row['cname'] );
				$saxueTpl -> assign( "curl", $this -> row['curl'] );
				$saxueTpl -> assign_by_ref( "caterows", $saxueCate['topic'] );
				// 专题文章分页处理
				$_totalpage = 1;
				$_pagesize = $this -> row['pnum'];
				if ( !empty( $_pagesize ) ) {
						$criteria = new criteriacompo( new criteria( 'topicid', $this -> topicid ) );
						$criteria -> add( new criteria( 'status', 1 ) );
						$articlecounts = $article_handler -> getcount( $criteria );
						$_totalpage = ceil( $articlecounts / $_pagesize );
						$_pages = array();
						for ( $_i = 1; $_i <= $_totalpage; $_i++ ) {
								$_pages[$_i] = saxue_geturl( 'topic_page', $this -> topicid, $_i );
						}
						$saxueTpl -> assign_by_ref( "pages", $_pages );
				}
				$saxueTpl -> assign( "totalpage", $_totalpage );
				if ( $_show ) {
						$_prepage = $_nextpage = '';
						if ( $_page < 1 ) $_page = 1;
						elseif ( $_page > $_totalpage ) $_page = $_totalpage;
						if ( $_totalpage > 1 ) {
								if ( ( $_page - 1 ) >= 1 ) $_prepage = $_pages[$_page - 1];
								if ( ( $_page + 1 ) <= $_totalpage ) $_nextpage = $_pages[$_page + 1];
						}
						$saxueTpl -> assign( "page", $_page );
						$saxueTpl -> assign( "prepage", $_prepage );
						$saxueTpl -> assign( "nextpage", $_nextpage );
						// 读取分页文章
						$_articles = $this -> loadarticle( $_pagesize, $_page );
						$saxueTpl -> assign_by_ref( "articles", $_articles );
				} else {
						$_tempdetail = $this -> gettemplate();
						for ( $_page = 1; $_page <= $_totalpage; $_page++ ) {
								$_prepage = $_nextpage = '';
								if ( $_totalpage > 1 ) {
										if ( ( $_page - 1 ) >= 1 ) $_prepage = $_pages[$_page - 1];
										if ( ( $_page + 1 ) <= $_totalpage ) $_nextpage = $_pages[$_page + 1];
								}
								$saxueTpl -> assign( "page", $_page );
								$saxueTpl -> assign( "prepage", $_prepage );
								$saxueTpl -> assign( "nextpage", $_nextpage );
								// 读取分页文章
								$_articles = $this -> loadarticle( $_pagesize, $_page );
								$saxueTpl -> assign_by_ref( "articles", $_articles );
								$_htmlfile = str_replace( $saxueConfigs['topic']['htmlurl'], $saxueConfigs['topic']['htmldir'], $this -> row['url'] );
								saxue_writefile( $_htmlfile, $saxueTpl -> fetch( $_tempdetail ) );
						}
						return $this -> row;
				}
		}
}