<?php
class saxuepage extends saxueobject {
		public $totalrows;
		public $pagerows;
		public $pagelinks;
		public $current;
		public $totalpages;
		public $total_page;
		public $linkurl;
		public $pagevar;

		public function saxuepage( $totalrows, $pagerows = 20, $current = 1, $pagelinks = 10, $pagevar = "page" ) {
				global $saxueTpl;
				$this -> totalrows = $totalrows;
				$this -> pagerows = $pagerows;
				$this -> current = $current;
				$this -> pagelinks = $pagelinks;
				$this -> pagevar = $pagevar;
				$this -> totalpages = @ceil( $this -> totalrows / $this -> pagerows );
				if ( defined( "SAXUE_MAX_PAGES" ) && ( 0 < SAXUE_MAX_PAGES ) && ( SAXUE_MAX_PAGES < $this -> totalpages ) ) {
						$this -> totalpages = intval( SAXUE_MAX_PAGES );
				} 
				if ( $this -> totalpages <= 1 ) {
						$this -> totalpages = 1;
				} 
				$this -> total_page = $this -> totalpages;
				if ( SAXUE_IN_MOBILE ) {
						$this -> pagelinks = 3;
				} 
				$this -> linkurl = saxue_addurlvars( array( $this -> pagevar => "" ), true, false );
				if ( isset( $saxueTpl ) && is_a( $saxueTpl, "saxuetpl" ) ) {
						$saxueTpl -> assign( "saxue_page_totalrows", $this -> totalrows );
						$saxueTpl -> assign( "saxue_page_pagerows", $this -> pagerows );
						$saxueTpl -> assign( "saxue_page_totalpages", $this -> totalpages );
						$saxueTpl -> assign( "saxue_page_pagelinks", $this -> pagelinks );
						$saxueTpl -> assign( "saxue_page_pagevar", $this -> pagevar );
						$saxueTpl -> assign( "saxue_page_linkurl", $this -> linkurl );
						$saxueTpl -> assign( "saxue_page_current", $this -> current );
						$saxueTpl -> assign( "saxue_page_currenturl", $this -> pageurl( $this -> current ) );
						$saxue_page_prev = ( 1 < $this -> current ? $this -> current - 1 : 0 );
						$saxue_page_prevurl = ( 0 < $saxue_page_prev ? $this -> pageurl( $saxue_page_prev ) : "#" );
						$saxue_page_next = ( $this -> current < $this -> totalpages ? $this -> current + 1 : 0 );
						$saxue_page_nexturl = ( 0 < $saxue_page_next ? $this -> pageurl( $saxue_page_next ) : "#" );
						$saxueTpl -> assign( "saxue_page_prev", $saxue_page_prev );
						$saxueTpl -> assign( "saxue_page_prevurl", $saxue_page_prevurl );
						$saxueTpl -> assign( "saxue_page_next", $saxue_page_next );
						$saxueTpl -> assign( "saxue_page_nexturl", $saxue_page_nexturl );
				} 
		} 

		public function setlink( $link = "", $addget = true, $addpost = false ) {
				global $saxueTpl;
				if ( !empty( $link ) ) {
						$this -> linkurl = $link;
				} else {
						$this -> linkurl = saxue_addurlvars( array( $this -> pagevar => "" ), $addget, $addpost );
				} 
				if ( isset( $saxueTpl ) && is_a( $saxueTpl, "saxuetpl" ) ) {
						$saxueTpl -> assign( "saxue_page_linkurl", $this -> linkurl );
				}
		} 

		public function pageurl( $page ) {
				if ( strpos( $this -> linkurl, "<{\$" . $this -> pagevar ) === false ) {
						$url = $this -> linkurl . $page;
				} else {
						$url = str_replace( array( "<{\$" . $this -> pagevar . "|subdirectory}>", "<{\$" . $this -> pagevar . "}>" ), array( saxue_getsubdir( $page ), $page ), $this -> linkurl );
				} 
				return $url;
		} 

		public function pagelink( $page, $char, $class = "" ) {
				$link_url = $this -> pageurl( $page );
				if ( empty( $class ) ) {
						return "<a href=\"" . $link_url . "\">" . $char . "</a>";
				} else {
						return "<a href=\"" . $link_url . "\" class=\"" . $class . "\">" . $char . "</a>";
				}
		} 

		public function first_page( $link = 1, $char = "" ) {
				if ( $char == "" ) {
						$char = "1";
				} 
				if ( $link == 1 ) {
						return $this -> pagelink( 1, $char, "first" );
				} else {
						return 1;
				}
		} 

		public function total_page( $link = 1, $char = "" ) {
				if ( $char == "" ) {
						$char = $this -> totalpages;
				} 
				if ( $link == 1 ) {
						return $this -> pagelink( $this -> totalpages, $char, "last" );
				} else {
						return $this -> totalpages;
				}
		} 

		public function pre_page( $char = "" ) {
				if ( $char == "" ) {
						$char = '&lt;';
				} 
				if ( 1 < $this -> current ) {
						return $this -> pagelink( $this -> current - 1, $char, "prev" );
				} else {
						return "";
				}
		} 

		public function next_page( $char = "" ) {
				if ( $char == "" ) {
						$char = '&gt;';
				} 
				if ( $this -> current < $this -> totalpages ) {
						return $this -> pagelink( $this -> current + 1, $char, "next" );
				} else {
						return "";
				}
		} 

		public function num_bar() {
				$pagelinks = &$this -> pagelinks;
				$mid = floor( $pagelinks / 2 );
				$last = $pagelinks - 1;
				$current = &$this -> current;
				$totalpage = &$this -> totalpages;
				$linkurl = &$this -> linkurl;
				$minpage = ( ( $current - $mid ) < 1 ? 1 : $current - $mid );
				$maxpage = $minpage + $last;
				if ( $totalpage < $maxpage ) {
						$maxpage = &$totalpage;
						$minpage = $maxpage - $last;
						$minpage = ( $minpage < 1 ? 1 : $minpage );
				} 
				$linkbar = "";
				for ( $i = $minpage; $i <= $maxpage; $i++ ) {
						$char = $i;
						if ( $i == $current ) {
								$linkchar = "<strong>" . $char . "</strong>";
						} else {
								$linkchar = $this -> pagelink( $i, $char );
						} 
						$linkbar .= $linkchar;
				} 
				return $linkbar;
		} 

		public function pre_group( $char = "" ) {
				$current = &$this -> current;
				$linkurl = &$this -> linkurl;
				$pagelinks = &$this -> pagelinks;
				$mid = floor( $pagelinks / 2 );
				$minpage = ( ( $current - $mid ) < 1 ? 1 : $current - $mid );
				$char = ( $char == "" ? "&lt;&lt;" : $char );
				$pgpage = ( $pagelinks < $minpage ? $minpage - $mid : 1 );
				return $this -> pagelink( $pgpage, $char, "pgroup" );
		} 

		public function next_group( $char = "" ) {
				$current = &$this -> current;
				$linkurl = &$this -> linkurl;
				$totalpage = &$this -> totalpages;
				$pagelinks = &$this -> pagelinks;
				$mid = floor( $pagelinks / 2 );
				$last = $pagelinks;
				$minpage = ( ( $current - $mid ) < 1 ? 1 : $current - $mid );
				$maxpage = $minpage + $last;
				if ( $totalpage < $maxpage ) {
						$maxpage = &$totalpage;
						$minpage = $maxpage - $last;
						$minpage = ( $minpage < 1 ? 1 : $minpage );
				} 
				$char = ( $char == "" ? "&gt;&gt;" : $char );
				$ngpage = ( ( $maxpage + $last ) < $totalpage ? $maxpage + $mid : $totalpage );
				return $this -> pagelink( $ngpage, $char, "ngroup" );
		} 

		public function whole_num_bar() {
				$num_bar = $this -> num_bar();
				return "<em id=\"pagestats\">" . $this -> totalpages . "页/" . $this -> totalrows . "条</em>" . $this -> first_page( 1, "首页" ) . $this -> pre_group() . $this -> pre_page() . $num_bar . $this -> next_page() . $this -> next_group() . $this -> total_page( 1, "尾页" );
		} 

		public function jump_form() {
				$linkurl = $this -> linkurl;
				$pos = strpos( $linkurl, "<{\$" . $this -> pagevar );
				if ( $pos === false ) {
						$urlcode = "'" . $linkurl . "'+this.value";
				} else {
						$urlcode = "'" . $linkurl . "'.replace('<{\$" . $this -> pagevar . "|subdirectory}>', '/' + Math.floor(this.value / 1000)).replace('<{\$" . $this -> pagevar . "}>', this.value)";
				} 
				$form = "<kbd><input name=\"page\" type=\"text\" size=\"3\" maxlength=\"6\" onkeydown=\"if(event.keyCode==13){window.location=" . $urlcode . "; return false;}\" title=\"输入页码，按回车快速跳转\" /></kbd>";
				return $form;
		} 

		public function whole_bar() {
				return "<div class=\"pagelink\" id=\"pagelink\">" . $this -> whole_num_bar() . $this -> jump_form() . "</div>";
		} 
} 
