<?php
function file_icon( $file ) {
		$ext_arr = array( 'doc', 'docx', 'ppt', 'xls', 'xlsx', 'txt', 'pdf', 'jpg', 'gif', 'png', 'bmp', 'jpeg', 'rar', 'zip', 'swf', 'flv', 'htm', 'html' );
		$ext = strtolower( trim( substr( strrchr( $file, '.' ), 1 ) ) );
		if ( in_array( $ext, $ext_arr ) ) return SAXUE_SKIN_SERVER . '/ext/' . $ext . '.gif';
		else return SAXUE_SKIN_SERVER . '/ext/unknow.gif';
} 
include "../core.php";
saxue_checkpower( 'attachs' );
$server = trim( $_REQUEST['server'] );
if ( empty( $server ) || !in_array( $server, array( 'local', 'oss', 'ftp' ) ) ) {
		$server = 'local';
}
switch ( $server ) {
		case 'local':
				$basedir = realpath( saxue_uploadpath() );
				if ( isset( $_POST['dosubmit'] ) && is_array( $_POST['attachs'] ) && 0 < count( $_POST['attachs'] ) ) {
						foreach( $_POST['attachs'] as $v ) {
								saxue_delfile( $basedir . '/' . $v );
						}
				}
				$dir = isset( $_REQUEST['dir'] ) && trim( $_REQUEST['dir'] ) ? str_replace( array( '..\\', '../', './', '.\\' ), '', trim( $_REQUEST['dir'] ) . '/' ) : '';
				$filepath = $basedir . '/' . $dir;
				$curpath = '/' . $dir;
				$list = glob( $filepath . '*' );
				if ( !empty( $list ) ) rsort( $list );
				$dirlist = $filelist = array();
				$k = 0;
				foreach( $list as $file ) {
						$filename = basename( $file );
						if ( is_dir( $file ) ) {
								$dirlist[$k]['dirname'] = $filename;
								$dirlist[$k]['dirurl'] = '?server=local&dir=' . ( isset( $_REQUEST['dir'] ) && !empty( $_REQUEST['dir'] ) ? stripslashes( $_REQUEST['dir'] ) . '/' : '' ) . $filename;
								$dirlist[$k]['dirtime'] = date( 'Y-m-d H:i', filemtime( $file ) );
						} else {
								$filelist[$k]['filename'] = $filename;
								$filelist[$k]['fileicon'] = file_icon( $filename );
								$filelist[$k]['filesize'] = round( filesize( $file ) / 1024, 2 );
								$filelist[$k]['filetime'] = date( 'Y-m-d H:i', filemtime( $file ) );
						} 
						++$k;
				} 
				if ( $dir != '' && $dir != '.' ) $parentpath = '?server=local&dir=' . stripslashes( dirname( $dir ) );
				else $parentpath = '?server=local';
				$attachsurl = saxue_uploadurl() . '/' . $dir;
				break;
		case 'ftp':
				if ( SAXUE_ATTACHS_FTPURL == '' ) {
						saxue_printfail( 'FTP服务器URL为空' );
				} elseif ( !preg_match( "/^(ftps?):\\/\\/([^:\\/]+):([^:\\/]*)@([0-9a-z\\-\\.]+)(:(\\d+))?([0-9a-z_\\-\\/\\.]*)/is", SAXUE_ATTACHS_FTPURL, $matches ) ) {
						saxue_printfail( 'FTP服务器URL格式错误' );
				} elseif ( strpos( $saxueConfigs['system']['attachsdir'], "\\" ) !== false ) {
						saxue_printfail( '系统附件目录错误，FTP模式目录只能为字母或数字' );
				} 
				include_once SAXUE_ROOT_PATH . "/lib/util/ftp.php";
				$ftpssl = strtolower( $matches[1] ) == "ftps" ? 1 : 0;
				$matches[6] = intval( trim( $matches[6] ) );
				$ftpport = 0 < $matches[6] ? $matches[6] : 21;
				$ftp = &saxueftp :: getinstance( $matches[4], $matches[2], $matches[3], ".", $ftpport, 0, $ftpssl );
				if ( !$ftp ) {
						saxue_printfail( '无法连接FTP服务器' );
				} 
				$matches[7] = trim( $matches[7] );
				if ( substr( SAXUE_ATTACHS_PATH, 0, 1 ) === '/' ) {
						$basedir = $matches[7] . SAXUE_ATTACHS_PATH;
						$ftpurl = SAXUE_ATTACHS_FTPURL . SAXUE_ATTACHS_PATH;
				} else {
						$basedir = $matches[7] . '/' . SAXUE_ATTACHS_PATH;
						$ftpurl = SAXUE_ATTACHS_FTPURL . '/' . SAXUE_ATTACHS_PATH;
				}
				if ( isset( $_POST['dosubmit'] ) && is_array( $_POST['attachs'] ) && 0 < count( $_POST['attachs'] ) ) {
						foreach( $_POST['attachs'] as $v ) {
								saxue_delfile( $ftpurl . '/' . $v );
						}
				}
				if ( !$ftp -> ftp_chdir( $basedir ) ) {
						saxue_printfail( '无法打开FTP服务器目录 ' . $basedir );
				} 
				$dir = isset( $_REQUEST['dir'] ) && trim( $_REQUEST['dir'] ) ? str_replace( array( '..\\', '../', './', '.\\' ), '', trim( $_REQUEST['dir'] ) . '/' ) : '';
				$curpath = '/' . $dir;
				$filepath = $dir;
				$list = $ftp -> ftp_rawlist( $filepath );
				$ftp -> ftp_close();
				if ( !$list ) {
						saxue_printfail( '附件目录 ' . $filepath . ' 是空目录' );
				} 
				$dirlist = $filelist = array();
				$k = 0;
				foreach( $list as $file ) {
						if ( ereg ( "([-d][rwxst-]+).* ([0-9]) ([a-zA-Z0-9]+).* ([a-zA-Z0-9]+).* ([0-9]*) ([a-zA-Z]+[0-9: ]*[0-9]) ( [0-9]{4}|[0-9]{2}:[0-9]{2}) (.+)", $file, $regs ) ) {
								$filename = mb_convert_encoding( $regs[8], "utf-8", "gb2312" );
								if ( $filename == '.' || $filename == '..' ) continue;
								$isdir = ( substr ( $regs[1], 0, 1 ) == "d" );
								if ( $isdir ) {
										$dirlist[$k]['dirname'] = $filename;
										$dirlist[$k]['dirurl'] = '?server=ftp&dir=' . ( isset( $_REQUEST['dir'] ) && !empty( $_REQUEST['dir'] ) ? stripslashes( $_REQUEST['dir'] ) . '/' : '' ) . $filename;
										if ( strlen( trim( $regs[7] ) ) == 4 ) {
												$dirlist[$k]['dirtime'] = date( 'Y-m-d', strtotime( $regs[6] . ' ' . trim( $regs[7] ) ) );
										} else {
												$dirlist[$k]['dirtime'] = date( 'Y-m-d H:i', strtotime( $regs[6] . ' ' . trim( $regs[7] ) ) );
										} 
								} else {
										$filelist[$k]['filename'] = $filename;
										$filelist[$k]['fileicon'] = file_icon( $filename );
										$filelist[$k]['filesize'] = round( $regs[5] / 1024, 2 );
										if ( strlen( trim( $regs[7] ) ) == 4 ) {
												$filelist[$k]['filetime'] = date( 'Y-m-d', strtotime( $regs[6] . ' ' . trim( $regs[7] ) ) );
										} else {
												$filelist[$k]['filetime'] = date( 'Y-m-d H:i', strtotime( $regs[6] . ' ' . trim( $regs[7] ) ) );
										} 
								} 
						} 
						++$k;
				} 
				if ( $dir != '' && $dir != '/' ) $parentpath = '?server=ftp&dir=' . stripslashes( dirname( $dir ) );
				else $parentpath = '?server=ftp';
				$attachsurl = saxue_uploadurl() . '/' . $dir;
				break;
		case 'oss':
				if ( OSS_ENDPOINT == '' || OSS_ACCESS_ID == '' || OSS_ACCESS_KEY == '' || OSS_BUCKET == '' ) {
						saxue_printfail( 'OSS参数没有设置' );
				}
				include SAXUE_ROOT_PATH . '/aliyun/oss_php52/sdk.class.php';
				if ( isset( $_POST['dosubmit'] ) && is_array( $_POST['attachs'] ) && 0 < count( $_POST['attachs'] ) ) {
						saxue_oss_del_objects( $_POST['attachs'] );
				}
				if ( empty( $_REQUEST['pagesize'] ) || !is_numeric( $_REQUEST['pagesize'] ) || !in_array( $_REQUEST['pagesize'], array( '20', '30', '50', '100' ) ) ) $_REQUEST['pagesize'] = 30;
				if ( !isset( $_REQUEST['marker'] ) ) $_REQUEST['marker'] = '';
				$dir = isset( $_REQUEST['dir'] ) && trim( $_REQUEST['dir'] ) ? str_replace( array( '..\\', '../', './', '.\\' ), '', trim( $_REQUEST['dir'] ) . '/' ) : '';
				$filepath = $dir;
				$curpath = '/' . $dir;
				// 取得文件信息
				$options = array(
					'delimiter' => '/',
					'prefix' => $filepath,
					'max-keys' => $_REQUEST['pagesize'],
					'marker' => $_REQUEST['marker']
				);
				$response = $oss_sdk_service -> list_object( OSS_BUCKET, $options );//print_r($response);exit();
				$dom = DOMDocument::loadXML( $response -> body );
				$dirlist = $filelist = array();
				$k = $dirnum = $filenum = 0;
				$marker = '';
				foreach( $dom -> getElementsByTagName( "CommonPrefixes" ) as $_dir ){
						$_filename = $_dir -> getElementsByTagName( "Prefix" ) -> item(0) -> nodeValue;
						$dirlist[$k]['dirname'] = pathinfo( $_filename, PATHINFO_BASENAME );
						$dirlist[$k]['dirurl'] = '?server=oss&dir=' . ( isset( $_REQUEST['dir'] ) && !empty( $_REQUEST['dir'] ) ? stripslashes( $_REQUEST['dir'] ) . '/' : '' ) . $dirlist[$k]['dirname'];
						$dirlist[$k]['dirtime'] = '';
						$marker = $_filename;
						++$k;
						++$dirnum;
				}
				foreach( $dom -> getElementsByTagName("Contents") as $_file ){
						$_filename = $_file -> getElementsByTagName( "Key" ) -> item(0) -> nodeValue;
						$_filesize = $_file -> getElementsByTagName( "Size" ) -> item(0) -> nodeValue;
						$_datetime = $_file -> getElementsByTagName( "LastModified" ) -> item(0) -> nodeValue;
						$filelist[$k]['filename'] = strtolower( pathinfo( $_filename, PATHINFO_BASENAME ) );
						$filelist[$k]['fileicon'] = file_icon( $filelist[$k]['filename'] );
						$filelist[$k]['filesize'] = round( $_filesize / 1024, 2 );
						$filelist[$k]['filetime'] = date( 'Y-m-d H:i', strtotime( $_datetime ) );
						$marker = $_filename;
						++$k;
						++$filenum;
				}
				if ( $dir != '' && $dir != '.' ) $parentpath = '?server=oss&dir=' . stripslashes( dirname( $dir ) );
				else $parentpath = '?server=oss';
				$attachsurl = OSS_URL . '/' . $dir;
				break;
}
include SAXUE_ADMIN_PATH . "/header.php";
if ( $server == 'oss' ) {
		$saxueTpl -> assign( "filenum", $filenum );
		$saxueTpl -> assign( "dirnum", $dirnum );
		$saxueTpl -> assign( "counts", $k );
		$saxueTpl -> assign( "thispage", '?server=oss&dir=' . $_REQUEST['dir'] . '&marker=' . $_REQUEST['marker'] );
		if ( $k < $_REQUEST['pagesize'] ) {
				$saxueTpl -> assign( "nextpage", '' );
		} else {
				$saxueTpl -> assign( "nextpage", '?server=oss&dir=' . $_REQUEST['dir'] . '&marker=' . $marker );
		}
}
$saxueTpl -> assign( "attachsurl", $attachsurl );
$saxueTpl -> assign( "dir", $dir );
$saxueTpl -> assign( "server", $server );
$saxueTpl -> assign( "parentpath", $parentpath );
$saxueTpl -> assign( "curpath", $curpath );
$saxueTpl -> assign_by_ref( "dirlist", $dirlist );
$saxueTpl -> assign_by_ref( "filelist", $filelist );
$saxueTset['saxue_contents_template'] = SAXUE_ADMIN_PATH . "/templates/attachs_file.html";
include SAXUE_ADMIN_PATH . "/footer.php";