<?php
function copypatch( $dirfrom, $dirto, $cover = '' ) {
		// 如果目录不存在，则建立之
		saxue_checkdir( $dirto, true );

		//打开当前目录
		$handle = opendir( $dirfrom );
		// 循环读取文件
		while ( false !== ( $file = readdir( $handle ) ) ) {
				if ( $file != '.' && $file != '..' ) {
						// 生成源文件名
						$filefrom = $dirfrom . DIRECTORY_SEPARATOR . $file; 
						// 生成目标文件名
						if ( $file == 'admin' && $dirto == SAXUE_WEB_PATH ) {
								// 后台目录
								$fileto = SAXUE_ADMIN_PATH;
						} elseif ( $file == 'SaxueFrame' ) {
								// SaxueFrame目录
								$fileto = SAXUE_ROOT_PATH;
						} else {
								$fileto = $dirto . DIRECTORY_SEPARATOR . $file;
						}
						if ( is_dir( $filefrom ) ) { 
								// 如果是子目录，则进行递归操作
								copypatch( $filefrom, $fileto, $cover );
						} else { 
								// 如果是文件，则直接用copy函数复制
								if ( !empty( $cover ) ) {
										if ( !copy( $filefrom, $fileto ) ) {
												ob_clean();
												saxue_printfail( '复制文件失败，请检查目录权限<br>源文件：' . $filefrom . '<br>目标文件：' . $fileto );
										} 
								} else {
										$fileext = fileext( $fileto );
										if ( !in_array( $fileext, array( 'html', 'css', 'js' ) ) || !file_exists( $fileto ) || ( $fileext == 'html' && false === strpos( $fileto, SAXUE_ROOT_PATH ) ) || ( in_array( $fileext, array( 'css', 'js' ) ) && false !== strpos( $fileto, SAXUE_WEB_PATH . '/public/admin' ) ) ) {
												if ( !copy( $filefrom, $fileto ) ) {
														ob_clean();
														saxue_printfail( '复制文件失败，请检查目录权限<br>源文件：' . $filefrom . '<br>目标文件：' . $fileto );
												} 
										} 
								} 
						} 
				} 
		} 
} 
function fileext( $filename ) {
		return strtolower( trim( substr( strrchr( $filename, '.' ), 1, 10 ) ) );
}
if ( !defined( "SAXUE_CORE_INCLUDE" ) ) {
		include "../core.php";
} 
saxue_checkpower( 'upgrade' );
// 初始化，获取更新列表
include SAXUE_DATA_PATH . '/version.php';
include SAXUE_ROOT_PATH . "/common/funaddon.php";
$url = 'http://www.saxue.com/api/getpatch.php?product=saxuearticle&releases=' . $saxueVersion['release'];
$data = saxue_sockopen( $url, 999 );
if ( empty( $data ) ) {
		saxue_printfail( '无法连接官方服务器，请重试或稍后更新' );
} 
$data = json_decode( $data, true );
if ( !$data['flag'] ) {
		saxue_printfail( $data['msg'] );
} 
if ( !empty( $_GET['do'] ) ) {
		if ( empty( $data['patchs'] ) ) {
				saxue_jumppage( $saxue_thisurl, '升级成功！', 1 );
		} 
		include SAXUE_ROOT_PATH . "/lib/util/pclzip.php"; 
		include SAXUE_ROOT_PATH . "/common/function.php";
		// 检查压缩包缓存文件夹
		$cachepath = SAXUE_DATA_PATH . '/download/upgrade';
		saxue_checkdir( $cachepath, true );
		// 根据版本下载zip升级包列表
		foreach ( $data['patchs'] as $k => $v ) {
				// 下载压缩包
				ob_clean();
				saxue_run( '升级包 V' . $v['edition'] . '_R' . $v['releases'] . '.zip 下载中，请稍候 ......', '?do=1&cover=' . $_GET['cover'] );
				$zipdata = saxue_sockopen( $v['downurl'], 999 );
				if ( empty( $zipdata ) ) {
						ob_clean();
						saxue_printfail( '升级包下载错误（V' . $v['edition'] . '_R' . $v['releases'] . '.zip）' );
				} 
				// 保存压缩包
				$zipfile = $cachepath . '/' . $v['releases'] . '.zip';
				saxue_writefile( $zipfile, $zipdata ); 

				// 解压压缩包
				ob_clean();
				saxue_run( '升级包 V' . $v['edition'] . '_R' . $v['releases'] . '.zip 下载成功，开始解压缩 ......', '?do=1&cover=' . $_GET['cover'] );
				$sourcepath = $cachepath . '/' . $v['releases'];
				saxue_checkdir( $sourcepath, true );
				$archive = new PclZip( $zipfile );
				if ( $archive -> extract( PCLZIP_OPT_PATH, $sourcepath, PCLZIP_OPT_REPLACE_NEWER ) == 0 ) {
						saxue_delfile( $zipfile );
						ob_clean();
						saxue_printfail( '升级包解压错误：<br>' . $archive -> errorInfo( true ) );
				} 
				saxue_delfile( $zipfile ); 

				// 复制文件到根目录
				ob_clean();
				saxue_run( '升级包 V' . $v['edition'] . '_R' . $v['releases'] . '.zip 解压缩成功，开始更新文件 ......', '?do=1&cover=' . $_GET['cover'] );
				copypatch( $sourcepath, SAXUE_WEB_PATH, $_GET['cover'] );

				// 执行升级文件
				ob_clean();
				saxue_run( '升级包 V' . $v['edition'] . '_R' . $v['releases'] . '.zip 文件更新成功，开始运行更新 ......', '?do=1&cover=' . $_GET['cover'] );
				if ( file_exists( $sourcepath . '/upgrade/upgrade.php' ) ) {
						@include $sourcepath . '/upgrade/upgrade.php';
				}

				//读取版本号写入version.php文件
				$saxueVersion['edition'] = $v['edition'];
				$saxueVersion['release'] = $v['releases'];
				$vstr = "<?php\n" . saxue_extractvars( 'saxueVersion', $saxueVersion );
				saxue_writefile( SAXUE_DATA_PATH . "/version.php", $vstr );

				//删除缓存文件夹
				saxue_delfolder( $sourcepath );

				// 升级成功提示
				$tmp_k = $k + 1;
				if( !empty( $data['patchs'][$tmp_k] ) ) {
						ob_clean();
						saxue_run( 'V' . $v['edition'] . '_R' . $v['releases'] . '.zip 升级成功<br />开始升级 V' . $data['patchs'][$tmp_k]['edition'] . '_R' . $data['patchs'][$tmp_k]['releases'] . '.zip', '?do=1&cover=' . $_GET['cover'] );
						sleep( 2 );
				}
		} 
		ob_clean();
		saxue_jumppage( 'upgrade.php', '升级完成！' );
} 
include_once( SAXUE_ADMIN_PATH . "/header.php" );
$saxueTpl -> assign( "flag", $data['flag'] );
$saxueTpl -> assign_by_ref( "patchs", $data['patchs'] );
$saxueTpl -> assign_by_ref( "version", $saxueVersion );
$saxueTset['saxue_contents_template'] = SAXUE_ADMIN_PATH . "/templates/upgrade.html";
include_once( SAXUE_ADMIN_PATH . "/footer.php" );