<?php
if ( !defined( "SAXUE_CORE_INCLUDE" ) ) {
		include_once( "../core.php" );
} 
require_once SAXUE_WEB_PATH . '/api/JSON.php';
$uid = intval( $_SESSION['saxueUserId'] );
if ( empty( $uid ) && empty( $_SESSION['saxueAdminId'] ) ) alert( '未登录' );

// 定义允许上传的文件扩展名
$ext_arr = array( 'image' => array( 'gif', 'jpg', 'jpeg', 'png', 'bmp' ),
		'flash' => array( 'swf', 'flv' ),
		'media' => array( 'swf', 'flv', 'mp3', 'wav', 'wma', 'wmv', 'mid', 'avi', 'mpg', 'asf', 'rm', 'rmvb' ),
		'file' => array( 'doc', 'docx', 'xls', 'xlsx', 'ppt', 'htm', 'html', 'txt', 'zip', 'rar', 'pdf' ), 
		);
// 最大文件大小 默认2000K
if ( 0 < SAXUE_ATTACHS_MAXSIZE ) {
		$max_size = 1024 * SAXUE_ATTACHS_MAXSIZE;
} else {
		$max_size = 2048000;
}
// PHP上传失败
if ( !empty( $_FILES['imgFile']['error'] ) ) {
		switch ( $_FILES['imgFile']['error'] ) {
				case '1':
						$error = '超过php.ini允许的大小。';
						break;
				case '2':
						$error = '超过表单允许的大小。';
						break;
				case '3':
						$error = '图片只有部分被上传。';
						break;
				case '4':
						$error = '请选择图片。';
						break;
				case '6':
						$error = '找不到临时目录。';
						break;
				case '7':
						$error = '写文件到硬盘出错。';
						break;
				case '8':
						$error = 'File upload stopped by extension。';
						break;
				case '999':
				default:
						$error = '未知错误。';
		} 
		alert( $error );
} 
// 有上传文件时
if ( empty( $_FILES ) === false ) {
		// 文件保存目录
		$save_path = saxue_uploadpath();
		// 文件保存目录URL
		$save_url = saxue_uploadurl();
		// FTP保存目录
		if ( SAXUE_ATTACHS_PATH != '' && strpos( SAXUE_ATTACHS_PATH, "\\" ) === false && SAXUE_ATTACHS_FTPURL != '' ) {
				if ( substr( SAXUE_ATTACHS_PATH, 0, 1 ) === '/' ) {
						$ftp_path = SAXUE_ATTACHS_FTPURL . SAXUE_ATTACHS_PATH;
				} else {
						$ftp_path = SAXUE_ATTACHS_FTPURL . '/' . SAXUE_ATTACHS_PATH;
				}
		} else {
				$ftp_path = '';
		}
		// 原文件名
		$file_name = $_FILES['imgFile']['name']; 
		// 服务器上临时文件名
		$tmp_name = $_FILES['imgFile']['tmp_name']; 
		// 文件大小
		$file_size = $_FILES['imgFile']['size']; 
		// 检查文件名
		if ( !$file_name ) {
				alert( "请选择文件。" );
		} 
		// 检查目录
		if ( @is_dir( $save_path ) === false ) {
				alert( "上传目录不存在。" );
		} 
		// 检查目录写权限
		if ( @is_writable( $save_path ) === false ) {
				alert( "上传目录没有写权限。" );
		} 
		// 检查是否已上传
		if ( @is_uploaded_file( $tmp_name ) === false ) {
				alert( "上传失败。" );
		} 
		// 检查文件大小
		if ( $file_size > $max_size ) {
				alert( "上传文件大小超过最大限制：" . ( $max_size / 1024 ) . "K。" );
		} 
		// 检查目录名
		$dir_name = empty( $_GET['dir'] ) ? 'image' : trim( $_GET['dir'] );
		if ( empty( $ext_arr[$dir_name] ) ) {
				alert( "目录名不正确。" );
		} 
		// 获得文件扩展名
		$temp_arr = explode( ".", $file_name );
		$file_ext = array_pop( $temp_arr );
		$file_ext = trim( $file_ext );
		$file_ext = strtolower( $file_ext ); 
		// 检查扩展名
		if ( in_array( $file_ext, $ext_arr[$dir_name] ) === false ) {
				alert( "上传文件扩展名是不允许的扩展名。\n只允许" . implode( ",", $ext_arr[$dir_name] ) . "格式。" );
		} 
		// 文件路径和URL
		$_filepath = $_fileurl = '';
		// 附件文件夹
		$_filepath .= $dir_name; 
		// 用户文件夹
		if ( !empty( $uid ) ) {
				$_filepath .= '/' . floor( intval( $uid ) / 1000 ) . '/' . $uid;
		}
		// 日期文件夹
		$_filepath .= '/' . date( "ym" );
		// 创建文件夹
		saxue_checkdir( $save_path . '/' . $_filepath, true );
		// 新文件名
		$_filepath .= '/' . date( "dHis" ) . mt_rand( 10000, 99999 ) . '.' . $file_ext;
		// 移动文件
		if ( move_uploaded_file( $tmp_name, $save_path . '/' . $_filepath ) === false ) {
				alert( "上传文件失败。" );
		} 
		@chmod( $save_path . '/' . $_filepath, 0644 );

		// 保存到远程服务器
		$_fileurl = $save_url . '/' . $_filepath;
		$_filein = $save_path . '/' . $_filepath;
		$_savein = 'local';
		if ( OSS_OPEN ) {
				// 保存文件到OSS
				include SAXUE_ROOT_PATH . '/aliyun/oss_php52/sdk.class.php';
				$ret = saxue_oss_upload( $_filepath, $save_path . '/' . $_filepath );
				if ( $ret['flag'] ) {
						$_fileurl = OSS_URL . '/' . $_filepath;
						$_filein = $_filepath;
						$_savein = 'oss';
						saxue_delfile( $save_path . '/' . $_filepath );
				} else {
						error_log( date( 'H:i:s' ) . '| upload_json: ' . $ret['msg'] . "\r\n\r\n", 3, SAXUE_ROOT_PATH . '/aliyun/oss_php52/logs/' . date( 'Ymd' ) . '.txt' );
				}
		} elseif ( SAXUE_ATTACHS_FTP && !empty( $ftp_path ) ) {
				// 开启FTP上传
				$ret = saxue_copyfile( $save_path . '/' . $_filepath, $ftp_path . '/' . $_filepath, 644, true );
				if ( $ret ) {
						$_savein = 'ftp';
						$_filein = $ftp_path . '/' . $_filepath;
				}
		}

		// 附件插入数据库
		$timeline = intval( $_REQUEST['timeline'] );
		if ( !empty( $timeline ) ) {
				include SAXUE_ROOT_PATH . "/model/attachs.php";
				$attachs_handler = saxueattachshandler :: getinstance( "saxueattachshandler" );
				$attachs = $attachs_handler -> create();
				$attachs -> setvar( 'timeline', $timeline );
				$attachs -> setvar( 'aid', 0 );
				$attachs -> setvar( 'savein', $_savein );
				$attachs -> setvar( 'filepath', str_replace( '\\', '/', $_filein ) );
				$attachs -> setvar( 'fileurl', $_fileurl );
				$attachs_handler -> insert( $attachs );
		}

		// 返回结果
		header( 'Content-type: text/html; charset=UTF-8' );
		$json = new Services_JSON();
		echo $json -> encode( array( 'error' => 0, 'url' => $_fileurl ) );
		exit;
} 

function alert( $msg ) {
		header( 'Content-type: text/html; charset=UTF-8' );
		$json = new Services_JSON();
		echo $json -> encode( array( 'error' => 1, 'message' => $msg ) );
		exit;
} 
