<?php
function get_chapters( $txtfile ) {
		if ( !file_exists( $txtfile ) ) {
				saxue_printfail( 'txt文件不存在' );
		}
		$file = fopen( $txtfile, "r" );
		$chapters = array();
		$lastchapter = $chaptercontent = '';
		$k = 0;
		while( !feof( $file ) ) {
				$text = fgets( $file );
				$text = trim( $text, "\xEF\xBB\xBF" );
				if( preg_match( "/^(\x{7b2c})\s*([\x{4e00}\x{4e8c}\x{4e09}\x{56db}\x{4e94}\x{516d}\x{4e03}\x{516b}\x{4e5d}\x{5341}\x{767e}\x{5343}\x{3007}\x{58f9}\x{8d30}\x{53c1}\x{8086}\x{4f0d}\x{9646}\x{67d2}\x{634c}\x{7396}\x{96f6}\x{62fe}\x{4f70}0-9]+)\s*([\x{7ae0}\x{8282}\x{56de}])\s*(.*)/u", trim( $text ), $matches ) ) {
						$chaptername = $matches[1] . $matches[2] . $matches[3];
						if ( strlen( $matches[4] ) > 0 ) $chaptername .= ' ' . $matches[4];
						if ( 20 < mb_strlen( $matches[4], 'UTF-8' ) || $chaptername == $lastchapter ) continue;
						$chaptercontent = trim( $chaptercontent );
						if ( !empty( $chaptercontent ) ) {
								$chapters[$k]['chaptercontent'] = saxue_formatcontent( $chaptercontent, true );
						}
						$chaptercontent = '';
						++$k;
						$chapters[$k]['chaptername'] = $chaptername;
						$lastchapter = $chaptername;
				} else {
						$chaptercontent .= $text;
				}
		}
		fclose( $file );
		$chapters[$k]['chaptercontent'] = saxue_setcontent( $chaptercontent );
		if ( $k == 0 ) {
				saxue_printfail( '没有提取到章节信息，请将txt先保存为utf-8格式再上传' );
		}
		if ( isset( $chapters[0] ) ) {
				$chapters[0]['chaptername'] = '引文';
		}
		return $chapters;
}
if ( !defined( "SAXUE_CORE_INCLUDE" ) ) {
		include "../../core.php";
} 
saxue_checkpower( 'article' );
$aid = intval( $_REQUEST['aid'] );
include SAXUE_ROOT_PATH . "/model/article.php";
$article_handler = saxuearticlehandler :: getinstance( "saxuearticlehandler" );
$article = $article_handler -> get( $aid );
if ( !is_object( $article ) ) {
		saxue_printfail( "文章不存在" );
} 
if ( $article -> getvar( 'ischapter' ) == 0 ) {
		saxue_printfail( "操作错误" );
} 
$file_path = SAXUE_CACHE_PATH . '/txt';
$file_txt = $file_path . '/' . $aid . '.txt';
if ( !isset( $_REQUEST['action'] ) ) $_REQUEST['action'] = 'upload';
switch ( $_REQUEST['action'] ) {
		case 'upload':
				if ( isset( $_POST['dosubmit'] ) ) {
						if ( 0 < $_FILES['txt']['error'] ) {
								saxue_delfile( $_FILES['txt']['tmp_name'] );
								saxue_printfail( 'txt文件上传失败' );
						} else {
								saxue_checkdir( $file_path, true );
								$ret = move_uploaded_file( $_FILES['txt']['tmp_name'], $file_txt );
								if ( !$ret ) {
										saxue_delfile( $_FILES['txt']['tmp_name'] );
										saxue_printfail( 'txt文件保存失败' );
								} 
								saxue_jumppage( '?action=checkchapter&aid=' . $aid, '上传成功，开始提取章节信息' );
						} 
				}
				if ( file_exists( $file_txt ) ) {
						$uploaded = 1;
				} else {
						$uploaded = 0;
				}
				$row = $article -> getvars( 'n' );
				include SAXUE_ROOT_PATH . "/model/article_data.php";
				$data_handler = saxuearticledatahandler :: getinstance( "saxuearticledatahandler" );
				$data_handler -> setdatatable( $row['tbnum'] );
				$data = $data_handler -> get( $aid );
				$row = $row + ( $data -> getvars( 'n' ) );
				// 父分类定位
				saxue_getconfigs( "cate", "article" );
				$catepos = array();
				$pid = $saxueCate['article'][$row['cid']]['pid'];
				if ( $pid ) {
						$catepos[] = $saxueCate['article'][$pid];
				}
				$catepos[] = $saxueCate['article'][$row['cid']];
				include SAXUE_ADMIN_PATH . "/header.php";
				$saxueTpl -> assign( "uploaded", $uploaded );
				$saxueTpl -> assign_by_ref( "row", $row );
				$saxueTpl -> assign_by_ref( "catepos", $catepos );
				$saxueTset['saxue_contents_template'] = SAXUE_WEB_PATH . "/article/templates/addtxt.html";
				include SAXUE_ADMIN_PATH . "/footer.php";
				break;
		case 'checkchapter':
				@set_time_limit( 0 );
				include SAXUE_ROOT_PATH . "/common/funpost.php";
				$chapters = get_chapters( $file_txt );
				$row = $article -> getvars( 'n' );
				include SAXUE_ROOT_PATH . "/model/article_data.php";
				$data_handler = saxuearticledatahandler :: getinstance( "saxuearticledatahandler" );
				$data_handler -> setdatatable( $row['tbnum'] );
				$data = $data_handler -> get( $aid );
				$row = $row + ( $data -> getvars( 'n' ) );
				// 父分类定位
				saxue_getconfigs( "cate", "article" );
				$catepos = array();
				$pid = $saxueCate['article'][$row['cid']]['pid'];
				if ( $pid ) {
						$catepos[] = $saxueCate['article'][$pid];
				}
				$catepos[] = $saxueCate['article'][$row['cid']];
				include SAXUE_ADMIN_PATH . "/header.php";
				$saxueTpl -> assign_by_ref( "row", $row );
				$saxueTpl -> assign_by_ref( "rows", $chapters );
				$saxueTpl -> assign_by_ref( "catepos", $catepos );
				$saxueTset['saxue_contents_template'] = SAXUE_WEB_PATH . "/article/templates/addtxt_chapter.html";
				include SAXUE_ADMIN_PATH . "/footer.php";
				break;
		case 'insert':
				@set_time_limit( 0 );
				include SAXUE_ROOT_PATH . "/common/funpost.php";
				saxue_getconfigs( "configs", "article" );
				$txtdir = $saxueConfigs['article']['txtdir'] . saxue_getsubdir( $aid ) . '/' . $aid;
				saxue_checkdir( $txtdir, true );
				include SAXUE_ROOT_PATH . "/model/article_chapter.php";
				$chapter_handler = saxuearticlechapterhandler :: getinstance( "saxuearticlechapterhandler" );
				$chapterorder = $chapter_handler -> getcount( new criteriacompo( new criteria( "aid", $aid ) ) );
				$chapters = get_chapters( $file_txt );
				foreach ( $chapters as $chapter ) {
						++$chapterorder;
						$chapter['chapterorder'] = $chapterorder;
						$chapter['posttime'] = SAXUE_NOW_TIME;
						$chapter['isvolume'] = 0;
						$chapter['aid'] = $aid;
						$newchapter = $chapter_handler -> create( true, $chapter );
						$chapter_handler -> insert( $newchapter );
						$chapterid  = $newchapter -> getvar( 'chapterid' );
						$txtfile = $txtdir . '/' . $chapterid . '.txt';
						saxue_writefile( $txtfile, $chapter['chaptercontent'] );
				}
				saxue_delfile( $txtfile );
				saxue_jumppage( 'chapter.php?aid=' . $aid, '章节入库成功，请重新生成章节目录结构和相关HTML页面' );
				break;
}
