<?php
//返回目录权限结果
function ReturnPathLevelResult( $path ){
		$testfile = $path . "/test.test";
		$fp = @fopen( $testfile, "wb" );
		if( $fp ) {
				@fclose( $fp );
				@unlink( $testfile );
				return 1;
		} else {
				return 0;
		}
}
//返回文件权限结果
function ReturnFileLevelResult( $filename ){
		return is_writable( $filename );
}
//检测目录权限
function check_filemod( $filename, $smallfile = "" ) {
		$succ = 1;
		$error = 0;
		if( !file_exists( $filename ) || ( $smallfile && !file_exists( $smallfile ) ) ) {
				return $error;
		}
		if( is_dir( $filename ) ) {
				if( !ReturnPathLevelResult( $filename ) ) {
						return $error;
				}
				if( $smallfile ) {
						if( is_dir( $smallfile ) ) {
								if( !ReturnPathLevelResult( $smallfile ) ) {
										return $error;
								}
						} else {
								if( !ReturnFileLevelResult( $smallfile ) ) {
										return $error;
								}
						}
				}
		} else {
				if( !ReturnFileLevelResult( $filename ) ) {
						return $error;
				}
				if(	$smallfile	) {
						if( !ReturnFileLevelResult( $smallfile ) ) {
								return $error;
						}
				}
		}
		return $succ;
}
function saxue_gethost( $showport = false ) {
		$protocol = isset( $_SERVER['HTTPS'] ) && strtolower( $_SERVER['HTTPS'] ) != "off" ? "https://" : "http://";
		if ( !empty( $_SERVER['HTTP_X_FORWARDED_HOST'] ) ) {
				$k = strpos( $_SERVER['HTTP_X_FORWARDED_HOST'], ":" );
				if ( 0 < $k ) {
						$host = substr( $_SERVER['HTTP_X_FORWARDED_HOST'], 0, $k );
						$port = substr( $_SERVER['HTTP_X_FORWARDED_HOST'], $k + 1 );
				} else {
						$host = $_SERVER['HTTP_X_FORWARDED_HOST'];
				} 
		} else if ( !empty( $_SERVER['HTTP_HOST'] ) ) {
				$k = strpos( $_SERVER['HTTP_HOST'], ":" );
				if ( 0 < $k ) {
						$host = substr( $_SERVER['HTTP_HOST'], 0, $k );
						$port = substr( $_SERVER['HTTP_HOST'], $k + 1 );
				} else {
						$host = $_SERVER['HTTP_HOST'];
				} 
		} else if ( !empty( $_SERVER['SERVER_NAME'] ) ) {
				$host = $_SERVER['SERVER_NAME'];
		} 
		if ( empty( $port ) ) {
				$port = $_SERVER['SERVER_PORT'];
		} 
		if ( $showport ) {
				return $protocol . $host . ":" . $port;
		} 
		return $protocol . $host;
} 
function saxue_safestring( $_str ) {
		$_len = strlen( $_str );
		for ( $_i = 0; $_i < $_len; ++$_i ) {
				$_tmpval = ord( $_str[$_i] );
				if ( 128 < $_tmpval ) {
						++$_i;
				} else {
						if ( $_tmpval == 34 || $_tmpval == 38 || $_tmpval == 39 || $_tmpval == 44 || $_tmpval == 47 || $_tmpval == 59 || $_tmpval == 60 || $_tmpval == 62 || $_tmpval == 92 || $_tmpval == 124 ) {
								return false;
						} 
						continue;
				} 
		} 
		return true;
} 
function showjsmessage( $message ) {
		echo '<script type="text/javascript">showmessage(\'' . addslashes( $message ) . ' \');</script>' . "\r\n";
		flush();
		ob_flush();
} 
function runquery( $sql ) {
		global $db_query;
		if ( !isset( $sql ) || empty( $sql ) ) return;
		if ( SAXUE_DB_PREFIX != 'saxue' ) {
				$sql = str_replace( ' saxue', ' ' . SAXUE_DB_PREFIX, $sql );
				$sql = str_replace( ' `saxue', ' `' . SAXUE_DB_PREFIX, $sql );
		} 
		$sql = str_replace( "\r", "\n", $sql );
		$ret = array();
		$num = 0;
		foreach( explode( ";\n", trim( $sql ) ) as $query ) {
				$ret[$num] = '';
				$queries = explode( "\n", trim( $query ) );
				foreach( $queries as $query ) {
						$ret[$num] .= ( isset( $query[0] ) && $query[0] == '#' ) || ( isset( $query[0] ) && isset( $query[1] ) && ( $query[0] . $query[1] == '--' || $query[0] . $query[1] == '/*' ) ) ? '' : $query;
				} 
				$num++;
		} 
		unset( $sql );
		foreach( $ret as $query ) {
				$query = trim( $query );
				if ( $query ) {
						$retflag = $db_query -> execute( $query );
						if ( !$retflag ) {
								showjsmessage( sprintf( '<span class="span-blue">SQL执行失败：<br />%s</span><br /><span class="span-red">错误提示：<br />%s</span>', saxue_htmlstr( $query ), saxue_htmlstr( $db_query -> db -> error() ) ) );
								echo '<script type="text/javascript">showcomplete(0);</script>';
								exit;
						} elseif ( substr( $query, 0, 12 ) == 'CREATE TABLE' ) {
								$name = preg_replace( "/CREATE TABLE IF NOT EXISTS `([a-z0-9_]+)` .*/is", "\\1", $query );
								showjsmessage( '建立数据表 ' . $name . ' ... <span class="span-green">成功</span>' );
						} 
				} 
		} 
} 
@define( 'SAXUE_INSTALL_MODE', '1' );
include "../core.php";
if ( !check_filemod( SAXUE_DATA_PATH . '/compiled' ) ) {
		exit('you may not have permissions to write to \'' . SAXUE_DATA_PATH . '/compiled/\'!');
}
include SAXUE_ROOT_PATH . "/lib/template/template.php";
$saxueTpl = &saxuetpl :: getinstance();
if ( is_file( SAXUE_DATA_PATH . "/install.lock" ) ) {
		saxue_printfail( '程序已经安装，如果您需要重新安装，请删除 ' . SAXUE_DATA_PATH . '/install.lock 文件，再访问本页面！' );
} 
if ( empty( $_REQUEST['step'] ) ) {
		$_REQUEST['step'] = 'license';
		@setcookie( "saxue_step['license']", 'license' );
} 
if ( @is_array( $_COOKIE['saxue_step'] ) && !in_array( $_REQUEST['step'], $_COOKIE['saxue_step'] ) ) {
		@header( "Location: index.php" );
		exit;
} 
switch ( $_REQUEST['step'] ) {
		case 'license':
				@setcookie( "saxue_step['checkenv']", 'checkenv' );
				break;
		case 'checkenv':
				@setcookie( "saxue_step['checkwrite']", 'checkwrite' );
				if ( floatval( PHP_VERSION ) < 5.0 ) {
						$state = 0;
				} else {
						$state = 1;
				} 
				$diskfree = function_exists( 'disk_free_space' ) ? floor( disk_free_space( SAXUE_WEB_PATH ) / ( 1024 * 1024 ) ) : 0;
				$sysinfo = array();
				$sysinfo[] = array( "name" => 'PHP版本', "value" => PHP_VERSION, "advice" => '>=5.0', "status" => $state );
				$sysinfo[] = array( "name" => '操作系统', "value" => PHP_OS, "advice" => 'Windows/Linux', "status" => 1 );
				$sysinfo[] = array( "name" => '服务器软件', "value" => $_SERVER['SERVER_SOFTWARE'], "advice" => 'Apache/IIS', "status" => 1 );
				$sysinfo[] = array( "name" => '支持Mysql', "value" => function_exists( "mysql_close" ) ? "YES" : "NO", "advice" => '必须支持', "status" => function_exists( "mysql_close" ) ? 1 : 0 );
				$sysinfo[] = array( "name" => '支持GD函数库', "value" => function_exists( "gd_info" ) ? "YES" : "NO", "advice" => '必须支持', "status" => function_exists( "gd_info" ) ? 1 : 0 );
				$sysinfo[] = array( "name" => '支持Session', "value" => function_exists( "session_start" ) ? "YES" : "NO", "advice" => '必须支持', "status" => function_exists( "session_start" ) ? 1 : 0 );
				$sysinfo[] = array( "name" => '正则表达式函数库', "value" => function_exists( "preg_match" ) ? "YES" : "NO", "advice" => '必须支持', "status" => function_exists( "preg_match" ) ? 1 : 0 );
				$sysinfo[] = array( "name" => '宽字符集库', "value" => function_exists( "mb_strlen" ) ? "YES" : "NO", "advice" => '必须支持', "status" => function_exists( "mb_strlen" ) ? 1 : 0 );
				$sysinfo[] = array( "name" => '附件上传', "value" => ini_get( 'file_uploads' ) ? ini_get( 'upload_max_filesize' ) : 'NO', "advice" => '必须支持', "status" => ini_get( 'file_uploads' ) ? 1 : 0 );
				$sysinfo[] = array( "name" => '开启全局变量', "value" => get_cfg_var( "register_globals" ) ? "ON" : "OFF", "advice" => '建议关闭', "status" => get_cfg_var( "register_globals" ) ? 2 : 1 );
				$sysinfo[] = array( "name" => '开启魔术引用', "value" => get_cfg_var( "magic_quotes_gpc" ) ? "ON" : "OFF", "advice" => '默认设置', "status" => 1 );
				$sysinfo[] = array( "name" => '显示错误消息', "value" => get_cfg_var( "display_errors" ) ? "ON" : "OFF", "advice" => '建议关闭', "status" => get_cfg_var( "display_errors" ) ? 2 : 1 );
				$sysinfo[] = array( "name" => '支持Zlib函数库', "value" => function_exists( "gzclose" ) ? "YES" : "NO", "advice" => '建议支持 [GZip]', "status" => function_exists( "gzclose" ) ? 1 : 2 );
				$sysinfo[] = array( "name" => '支持Socket', "value" => function_exists( "fsockopen" ) ? "YES" : "NO", "advice" => '建议支持 [邮件]', "status" => function_exists( "fsockopen" ) ? 1 : 2 );
				$sysinfo[] = array( "name" => '支持Curl', "value" => function_exists( 'curl_init' ) && function_exists( 'curl_exec' ) ? "YES" : "NO", "advice" => '建议支持 [升级]', "status" => function_exists( 'curl_init' ) && function_exists( 'curl_exec' ) ? 1 : 2 );
				$sysinfo[] = array( "name" => '支持Memcached', "value" => class_exists( "Memcache" ) ? "YES" : "NO", "advice" => '建议支持 [缓存]', "status" => class_exists( "Memcache" ) ? 1 : 2 );
				$sysinfo[] = array( "name" => '磁盘空间', "value" => $diskfree > 0 ? $diskfree . 'M' : '未知', "advice" => '>=100M', "status" => $diskfree > 100 ? 1 : 2 );
				$check_status = 0;
				for ( $i = 0; $i < count( $sysinfo ); ++$i ) {
						if ( $sysinfo[$i]['status'] == 0 ) {
								$check_status = 0;
								break;
						} 
						$check_status = 1;
				} 
				$saxueTpl -> assign( "check_status", $check_status );
				$saxueTpl -> assign( "sysinfo", $sysinfo );
				break;
		case 'checkwrite':
				@setcookie( "saxue_step['configs']", 'configs' );
				$filepath = array();
				$filepath[] = array( "path" => SAXUE_WEB_PATH, "type" => "dir", "status" => 0, "name" => '网站根目录(不要应用于子目录)' );
				$filepath[] = array( "path" => SAXUE_WEB_PATH . '/plugin', "type" => "dir", "status" => 0, "name" => '插件目录' );
				$filepath[] = array( "path" => SAXUE_DATA_PATH . '/version.php', "type" => "file", "status" => 0, "name" => '程序版本' );
				$filepath[] = array( "path" => SAXUE_DATA_PATH . '/cache', "type" => "dir", "status" => 0, "name" => '缓存目录' );
				$filepath[] = array( "path" => SAXUE_DATA_PATH . '/compiled', "type" => "dir", "status" => 0, "name" => '编译目录' );
				$filepath[] = array( "path" => SAXUE_DATA_PATH . '/configs', "type" => "dir", "status" => 0, "name" => '配置文件目录' );
				$filepath[] = array( "path" => SAXUE_DATA_PATH . '/configs/db.php', "type" => "file", "status" => 0, "name" => '数据库配置文件' );
				foreach( $filepath as $key => $item ) {
						if ( $item['type'] == 'dir' && !is_dir( $item['path'] ) ) {
								$filepath[$key]['status'] = 2;
						} else {
								$filepath[$key]['status'] = check_filemod( $item['path'] );
						} 
						if ( false === strpos( $item['path'], SAXUE_WEB_PATH ) ) {
								$filepath[$key]['path'] = str_replace( SAXUE_ROOT_PATH, '/SaxueFrame', $item['path'] );
						} else {
								$filepath[$key]['path'] = substr( $item['path'], strlen( SAXUE_WEB_PATH ) );
						}
				} 
				$check_status = 0;
				for ( $i = 0; $i < count( $filepath ); ++$i ) {
						if ( $filepath[$i]['status'] == 0 ) {
								$check_status = 0;
								break;
						} 
						$check_status = 1;
				} 
				$saxueTpl -> assign( "check_status", $check_status );
				$saxueTpl -> assign( "filepath", $filepath );
				break;
		case 'configs':
				@setcookie( "saxue_step['database']", 'database' );
				$tmpvar = dirname( dirname( $_SERVER['PHP_SELF'] ) );
				if ( $tmpvar == "/" || $tmpvar == "\\" ) {
						$tmpvar = "";
				} 
				$saxueTpl -> assign( "local_root", saxue_gethost() . $tmpvar );
				break;
		case 'database':
				@setcookie( "saxue_step['install']", 'install' );
				@session_start();
				foreach ( $GLOBALS['_POST'] as $k => $v ) {
						$GLOBALS['_POST'][$k] = str_replace( array( "`", "'", "\"", "\\" ), "", $_POST[$k] );
				} 
				$GLOBALS['_POST']['local_root'] = trim( $_POST['local_root'] );
				$GLOBALS['_POST']['mysql_host'] = trim( $_POST['mysql_host'] );
				$GLOBALS['_POST']['mysql_prefix'] = trim( $_POST['mysql_prefix'] );
				$GLOBALS['_POST']['mysql_name'] = trim( $_POST['mysql_name'] );
				$GLOBALS['_POST']['mysql_user'] = trim( $_POST['mysql_user'] );
				$GLOBALS['_POST']['mysql_pass'] = trim( $_POST['mysql_pass'] );
				$GLOBALS['_POST']['mysql_charset'] = 'utf8';
				$GLOBALS['_POST']['setup_table'] = isset( $_POST['setup_table'] ) ? trim( $_POST['setup_table'] ) : "";
				$GLOBALS['_POST']['system_user'] = trim( $_POST['system_user'] );
				$GLOBALS['_POST']['system_pass'] = trim( $_POST['system_pass'] );
				$GLOBALS['_POST']['system_pass_confirm'] = trim( $_POST['system_pass_confirm'] );
				$GLOBALS['_POST']['admin_dir'] = trim( $_POST['admin_dir'] );
				include_once( SAXUE_ROOT_PATH . "/lib/database/mysql/db.php" );
				$db_query = new saxuemysqldatabase();
				$errtext = "";
				if ( method_exists( $db_query, "setdbset" ) ) {
						$dbset = array( "dbtype" => "mysql",
								"dbhost" => $_POST['mysql_host'],
								"dbuser" => $_POST['mysql_user'],
								"dbpass" => $_POST['mysql_pass'],
								"dbname" => "",
								"dbpconnect" => 0,
								"dbcharset" => $_POST['mysql_charset'],
								"dbusage" => 0 
								);
						$db_query -> setdbset( $dbset );
						$isconnect = $db_query -> connect( true );
				} else {
						$isconnect = $db_query -> connect( $_POST['mysql_host'], $_POST['mysql_user'], $_POST['mysql_pass'], $_POST['mysql_name'], false );
				} 
				if ( $isconnect ) {
						if ( $_POST['setup_table'] == "yes" ) {
								if ( preg_match( "/^[A-Za-z0-9_\\-]+\$/", $_POST['mysql_name'] ) ) {
										if ( !$db_query -> query( "DROP DATABASE IF EXISTS `" . $_POST['mysql_name'] . "`" ) ) {
												$errtext .= "删除原数据库失败！<br />";
										} 
										$mysql_version = @mysql_get_server_info();
										if ( $mysql_version < "4.1" ) {
												$sql = "CREATE DATABASE `" . $_POST['mysql_name'] . "`";
										} else {
												$sql = "CREATE DATABASE `" . $_POST['mysql_name'] . "` DEFAULT CHARACTER SET " . $_POST['mysql_charset'];
										} 
										if ( !$db_query -> query( $sql ) ) {
												$errtext .= "创建新数据库失败！<br />";
										} 
								} else {
										$errtext .= "数据库名称格式错误！<br />";
								} 
						} else if ( !mysql_select_db( $_POST['mysql_name'] ) ) {
								$errtext .= sprintf( "数据库 %s 不存在！", htmlspecialchars( $_POST['mysql_name'] ) ) . "<br />";
						} 
						$modadmin = 0;
						if ( empty( $errtext ) ) {
								$config_file = SAXUE_DATA_PATH . '/configs/define.php';
								$config_content = saxue_readfile( $config_file );
								$config_content = preg_replace( "/define\('SAXUE_URL','(.*?)'/is", "define('SAXUE_URL','" . $_POST['local_root'] . "'", $config_content );
								if ( !saxue_writefile( $config_file, $config_content ) ) {
										$errtext .= "写入配置文件失败！请手动修改 ". SAXUE_DATA_PATH . " 目录权限<br />";
								} 

								$db_file = SAXUE_DATA_PATH . '/configs/db.php';
								$db_content = saxue_readfile( $db_file );
								$db_content = preg_replace( "/define\('SAXUE_DB_HOST','(.*?)'/is", "define('SAXUE_DB_HOST','" . $_POST['mysql_host'] . "'", $db_content );
								$db_content = preg_replace( "/define\('SAXUE_DB_PREFIX','(.*?)'/is", "define('SAXUE_DB_PREFIX','" . $_POST['mysql_prefix'] . "'", $db_content );
								$db_content = preg_replace( "/define\('SAXUE_DB_NAME','(.*?)'/is", "define('SAXUE_DB_NAME','" . $_POST['mysql_name'] . "'", $db_content );
								$db_content = preg_replace( "/define\('SAXUE_DB_USER','(.*?)'/is", "define('SAXUE_DB_USER','" . $_POST['mysql_user'] . "'", $db_content );
								$db_content = preg_replace( "/define\('SAXUE_DB_PASS','(.*?)'/is", "define('SAXUE_DB_PASS','" . $_POST['mysql_pass'] . "'", $db_content );
								$db_content = preg_replace( "/define\('SAXUE_DB_CHARSET','(.*?)'/is", "define('SAXUE_DB_CHARSET','" . $_POST['mysql_charset'] . "'", $db_content );
								if ( strlen( $_POST['admin_dir'] ) > 0 && $_POST['admin_dir'] != 'admin' ) {
										if ( rename( "../admin", "../" . $_POST['admin_dir'] ) ) {
												$db_content = preg_replace( "/define\('SAXUE_ADMIN_DIR','(.*?)'/is", "define('SAXUE_ADMIN_DIR','" . $_POST['admin_dir'] . "'", $db_content );
												$modadmin = 1;
										} else {
												$modadmin = 2;
										} 
								}
								if ( !saxue_writefile( $db_file, $db_content ) ) {
										$errtext .= "写入配置文件失败！请手动修改 ". SAXUE_DATA_PATH . " 目录权限<br />";
								} 
						} 
						if ( $_POST['system_user'] && $_POST['system_pass'] && $_POST['system_pass_confirm'] ) {
								if ( !saxue_safestring( $_POST['system_user'] ) || strpos( $_POST['system_user'], "　" ) !== false ) {
										$errtext .= "系统管理员账号格式错误！<br />";
								} 
								if ( strlen( $_POST['system_pass'] ) < 6 ) {
										$errtext .= "管理员密码至少6位！<br />";
								} 
								if ( $_POST['system_pass'] != $_POST['system_pass_confirm'] ) {
										$errtext .= "两次输入的密码不一致！<br />";
								} 
						} 
				} else {
						$errtext .= "Mysql数据库主机连接失败！请重新设置。<br />" . mysql_error() . "<br />";
				} 
				if ( empty( $errtext ) ) {
						$link_status = 1;
						$GLOBALS['_SESSION']['system_user'] = $_POST['system_user'];
						$GLOBALS['_SESSION']['system_pass'] = $_POST['system_pass'];
						if ( $modadmin == 1 ) $GLOBALS['_SESSION']['admin_dir'] = $_POST['admin_dir'];
						else $GLOBALS['_SESSION']['admin_dir'] = '';
						$GLOBALS['_SESSION']['local_root'] = $_POST['local_root'];
						$GLOBALS['_SESSION']['mysql_host'] = $_POST['mysql_host'];
						$GLOBALS['_SESSION']['mysql_prefix'] = $_POST['mysql_prefix'];
						$GLOBALS['_SESSION']['mysql_name'] = $_POST['mysql_name'];
						$GLOBALS['_SESSION']['mysql_user'] = $_POST['mysql_user'];
						$GLOBALS['_SESSION']['mysql_pass'] = $_POST['mysql_pass'];
						$GLOBALS['_SESSION']['mysql_charset'] = $_POST['mysql_charset'];
						$saxueTpl -> assign( "step_content", 'Mysql数据库服务器连接成功！<br />配置文件写入成功！' );
				} else {
						$link_status = 0;
						$saxueTpl -> assign( "step_content", $errtext );
				} 
				$saxueTpl -> assign( "link_status", $link_status );
				$saxueTpl -> assign( "modadmin", $modadmin );
				break;
		case 'install':
				@session_start();
				saxue_includedb();
				$db_query = saxuequeryhandler :: getinstance( 'saxuequeryhandler' );
				break;
} 
$saxueTpl -> setcaching( 0 );
$saxueTpl -> assign( "saxue_content", $saxueTpl -> fetch( SAXUE_WEB_PATH . '/install/templates/' . $_REQUEST['step'] . '.html' ) );
$saxueTpl -> display( SAXUE_WEB_PATH . "/install/templates/theme.html" );
if ( $_REQUEST['step'] == 'install' ) {
		// 检查SQL文件
		if ( !file_exists( SAXUE_WEB_PATH . "/install/sql/struct.sql" ) ) {
				showjsmessage( '检查SQL文件 ... <span class="span-red">SQL文件 /install/sql/struct.sql 不存在</span>' );
				echo '<script type="text/javascript">showcomplete(0);</script>';
				exit;
		} 
		showjsmessage( '检查SQL文件 ... <span class="span-green">成功</span>' ); 
		if ( !file_exists( SAXUE_WEB_PATH . "/install/sql/data.sql" ) ) {
				showjsmessage( '检查SQL文件 ... <span class="span-red">SQL文件 /install/sql/data.sql 不存在</span>' );
				echo '<script type="text/javascript">showcomplete(0);</script>';
				exit;
		} 
		showjsmessage( '检查SQL文件 ... <span class="span-green">成功</span>' ); 
		// 创建数据表
		$sql = saxue_readfile( SAXUE_WEB_PATH . "/install/sql/struct.sql" );
		$sql = str_replace( "\r\n", "\n", $sql );
		runquery( $sql ); 
		$sql = saxue_readfile( SAXUE_WEB_PATH . "/install/sql/data.sql" );
		$sql = str_replace( "\r\n", "\n", $sql );
		runquery( $sql ); 
		// 写入管理员帐号密码
		if ( $_SESSION['system_user'] && $_SESSION['system_pass'] ) {
				if ( !$db_query -> execute( "DELETE FROM " . saxue_dbprefix( "system_admin" ) ) ) {
						showjsmessage( '写入管理员帐号信息 ... <span class="span-blue">清空原账号数据失败，请使用默认账号登录！</span>' );
				} else {
						include_once( SAXUE_ROOT_PATH . "/model/system_admin.php" );
						$admin_handler = &saxuesystemadminhandler :: getinstance( "saxuesystemadminhandler" );
						if ( !$db_query -> execute( "INSERT INTO `" . saxue_dbprefix( "system_admin" ) . "` (`account`, `password`, `role`, `status`, `isfounder`, `lasttime`, `lastip`) VALUES ('" . $_SESSION['system_user'] . "', '" . $admin_handler -> encryptpass( $_SESSION['system_pass'] ) . "', 0, 1, 1, 0, '')" ) ) {
								showjsmessage( '写入管理员帐号信息 ... <span class="span-red">插入新账号数据失败！</span>' );
								echo '<script type="text/javascript">showcomplete(0);</script>';
								exit;
						} else {
								showjsmessage( '写入管理员帐号信息 ... <span class="span-green">成功</span>' );
						} 
				} 
		} 
		// 更新数据库设置
		if ( strlen( $_SESSION['local_root'] ) > 0 ) {
				$db_query -> execute( "UPDATE " . saxue_dbprefix( "system_configs" ) . " SET cvalue = '" . saxue_dbslashes( $_SESSION['local_root'] ) . "' WHERE gname='system' AND cname='SAXUE_URL';" );
		} 
		unset( $GLOBALS['_SESSION'] ); 
		@touch( SAXUE_DATA_PATH . "/install.lock" );
		setcookie( "saxue_step" );
		saxue_delfolder( SAXUE_WEB_PATH . '/install' );
		showjsmessage( '<span class="span-green">安装完成</span>' );
		echo '<script type="text/javascript">showcomplete(1);</script>';
} 
