<?php 
// 自动创建用户
function saxue_oauth_reg() {
		global $users_handler;
		global $saxueConfigs;
		if ( !is_a( $users_handler, "saxuememberusershandler" ) ) {
				include SAXUE_ROOT_PATH . "/model/member_users.php";
				$users_handler = &saxuememberusershandler :: getinstance( "saxuememberusershandler" );
		} 
		if ( !isset( $saxueConfigs['member'] ) ) {
				saxue_getconfigs( 'configs', 'member' );
		}
		$newUser = $users_handler -> create();
		$newUser -> setvar( "uid", 0 );
		$newUser -> setvar( "status", 1 );
		$newUser -> setvar( "uname", 'u_' . SAXUE_NOW_TIME );
		// 注册奖励
		$saxueConfigs['member']['regscore'] = intval( $saxueConfigs['member']['regscore'] );
		$saxueConfigs['member']['regmoney'] = saxue_dround( $saxueConfigs['member']['regmoney'] );
		$newUser -> setvar( "score", $saxueConfigs['member']['regscore'] );
		$newUser -> setvar( "money", $saxueConfigs['member']['regmoney'] );
		// 注册失败
		if ( !$users_handler -> insert( $newUser ) ) {
				return false;
		} 
		$uid = $newUser -> getvar( "uid", "n" );
		// 保存头像
		global $oauth_info;
		$avatar = 0;
		if ( !empty( $oauth_info['avatar'] ) && false === strpos( $oauth_info['avatar'], SAXUE_SKIN_URL ) ) {
				include_once SAXUE_ROOT_PATH . "/common/funpost.php";
				$basedir = saxue_uploadpath( 'avatar' ) . saxue_getsubdir( $uid );
				saxue_checkdir( $basedir, true );
				$avatarfile = $basedir . "/" . $uid . '.jpg';
				$avatarfile_s = $basedir . "/" . $uid . 's.jpg';
				$avatarfile_i = $basedir . "/" . $uid . 'i.jpg';
				if ( file_remote_copy( $oauth_info['avatar'], $avatarfile ) ) {
						file_remote_copy( $oauth_info['avatar_s'], $avatarfile_s );
						file_remote_copy( $oauth_info['avatar_i'], $avatarfile_i );
						$avatar = 1;
				}
		}
		// 更新用户
		$uname = 'u_' . $uid;
		if ( 0 == $users_handler -> getcount( new criteria( "uname", $uname ) ) ) {
				$newUser -> setvar( "uname", $uname );
				$newUser -> setvar( "avatar", $avatar );
				$newUser -> unsetnew();
				$users_handler -> insert( $newUser );
		} 
		// 用户附表
		include_once SAXUE_ROOT_PATH . "/model/member_userdata.php";
		$userdata_handler = &saxuememberuserdatahandler :: getinstance( "saxuememberuserdatahandler" ); 
		$userdata = $userdata_handler -> create();
		$userdata -> setvar( "uid", $uid );
		$userdata -> setvar( "regtime", SAXUE_NOW_TIME );
		$userdata -> setvar( "regip", saxue_userip() );
		$userdata_handler -> insert( $userdata );
		// 注册奖励积分记录
		if ( $saxueConfigs['member']['regscore'] > 0 ) {
				include_once SAXUE_ROOT_PATH . "/model/member_score.php";
				$score_handler = &saxuememberscorehandler :: getinstance( "saxuememberscorehandler" );
				$_record = array( 'uid' => $uid, 'amount' => $saxueConfigs['member']['regscore'], 'balance' => $saxueConfigs['member']['regscore'], 'type' => 1 );
				$score_handler -> addlog( $_record );
		}
		//  注册奖励资金记录
		if ( $saxueConfigs['member']['regmoney'] > 0 ) {
				include_once SAXUE_ROOT_PATH . "/model/member_money.php";
				$money_handler = &saxuemembermoneyhandler :: getinstance( "saxuemembermoneyhandler" );
				$_record = array( 'uid' => $uid, 'amount' => $saxueConfigs['member']['regmoney'], 'balance' => $saxueConfigs['member']['regmoney'], 'type' => 1 );
				$money_handler -> addlog( $_record );
		}
		return $newUser;
}
// 登录成功处理
function saxue_oauth_login( $user ) {
		global $users_handler;
		global $saxueConfigs;
		if ( !isset( $saxueConfigs['member'] ) ) {
				saxue_getconfigs( 'configs', 'member' );
		}
		if ( !is_a( $users_handler, "saxuememberusershandler" ) ) {
				include_once SAXUE_ROOT_PATH . "/model/member_users.php";
				$users_handler = &saxuememberusershandler :: getinstance( "saxuememberusershandler" );
		} 
		$saxueConfigs['member']['loginscore'] = intval( $saxueConfigs['member']['loginscore'] );
		include_once SAXUE_ROOT_PATH . "/model/member_userdata.php";
		$userdata_handler = &saxuememberuserdatahandler :: getinstance( "saxuememberuserdatahandler" );
		$userdata = $userdata_handler -> get( $user -> getvar( 'uid' ) );
		$prelogintime = $userdata -> getvar( "logintime", "n" );
		$logintimes = $userdata -> getvar( "logintimes", "n" );
		++$logintimes;
		$loginscore = false;
		if ( $saxueConfigs['member']['loginscore'] > 0 && date( 'Y-m-d', $prelogintime ) != date( "Y-m-d" ) ) {
				$score = $user -> getvar( "score", "n" );
				$score += $saxueConfigs['member']['loginscore'];
				$user -> setvar( "score", $score );
				$user -> unsetnew();
				$users_handler -> insert( $user );
				$loginscore = true;
		}
		$userdata -> setvar( "logintimes", $logintimes );
		$userdata -> setvar( "prelogintime", $prelogintime );
		$userdata -> setvar( "preloginip", $user -> getvar( "loginip", "n" ) );
		$userdata -> setvar( "logintime", SAXUE_NOW_TIME );
		$userdata -> setvar( "loginip", saxue_userip() );
		$userdata -> unsetnew();
		$userdata_handler -> insert( $userdata );
		// 用户SESSION
		$GLOBALS['_SESSION']['saxueUserId'] = $user -> getvar( "uid", "n" );
		$GLOBALS['_SESSION']['saxueUserName'] = $user -> getvar( "uname", "n" );
		$GLOBALS['_SESSION']['saxueUserEmail'] = $user -> getvar( "email", "n" );
		$GLOBALS['_SESSION']['saxueUserScore'] = $user -> getvar( "score", "n" );
		$GLOBALS['_SESSION']['saxueUserMoney'] = $user -> getvar( "money", "n" );
		$GLOBALS['_SESSION']['HTTP_REFERER'] = '';
		if ( $loginscore ) {
				include_once SAXUE_ROOT_PATH . "/model/member_score.php";
				$score_handler = &saxuememberscorehandler :: getinstance( "saxuememberscorehandler" );
				$_record = array( 'uid' => $_SESSION['saxueUserId'], 'amount' => $saxueConfigs['member']['loginscore'], 'balance' => $score, 'type' => 2 );
				$score_handler -> addlog( $_record );
		}
		return true;
}
// 新用户绑定处理
function saxue_oauth_handle( $oid = 0 ) {
		global $saxueOauth;
		if ( SAXUE_IN_MOBILE || $saxueOauth[$_GET['site']]['bindtype'] == 2 ) {
				// 自动创建用户
				$user = saxue_oauth_reg();
				// 绑定用户
				global $oauth_handler;
				global $oauth_info;
				if ( $user !== false && $oauth_handler -> bind( $user -> getvar( 'uid' ), $_GET['site'], $oauth_info ) ) {
						// 删除接口session和cookie
						del_token(); 
						// 登录次数加1，更新最后登录时间
						$oauth_handler -> updateoauth( $oid );
						// 进行登录成功后的用户处理操作
						saxue_oauth_login( $user );
						saxue_jumppage( $_GET['backurl'] );
				}
				saxue_jumppage( $_GET['backurl'], $saxueOauth[$_GET['site']]['name'] . '登录成功，更多功能需要完善账户资料或绑定已有帐号' );
		} elseif ( $saxueOauth[$_GET['site']]['bindtype'] == 1 ) {
				// 跳转注册绑定界面
				saxue_jumppage( '/member/oauthbind.php?site=' . $_GET['site'], '请完善账户资料或绑定已有帐号' );
		} else {
				// 暂不绑定，设置临时用户SESSION并跳转
				saxue_jumppage( $_GET['backurl'], $saxueOauth[$_GET['site']]['name'] . '登录成功，更多功能需要完善账户资料或绑定已有帐号' );
		}
}

// 登录回调页面
include "../core.php";
saxue_getconfigs( 'oauth', 'member' );
if ( empty( $_GET['site'] ) || !isset( $saxueOauth[$_GET['site']] ) || !$saxueOauth[$_GET['site']]['open'] ) {
		saxue_printfail( '登录接口 ' . $saxueOauth[$_GET['site']]['name'] . ' 不存在或者已关闭' );
} 

include SAXUE_ROOT_PATH . '/oauth/' . $_GET['site'] . '.php';
$openid = get_oauthid();
if ( empty( $openid ) ) {
		del_token();
		saxue_jumppage( '/member/login.php', $saxueOauth[$_GET['site']]['name'] . ' OPENID获取失败' );
} 
$_SESSION['saxueUserOauth'] = $_GET['site'];
if ( empty( $_GET['backurl'] ) ) {
		$_GET['backurl'] = '/member/';
}
$oauth_info = get_oauthinfo();
// 导入oauth接口类
include SAXUE_ROOT_PATH . "/model/member_oauth.php";
$oauth_handler = &saxuememberoauthhandler :: getinstance( "saxuememberoauthhandler" );
$result = $oauth_handler -> getuser( $oauth_info['openid'], $_GET['site'] );
if ( $result != false ) {
		// openid已存在
		$_SESSION['saxueUserId'] = 0;
		$_SESSION['saxueUserName'] = $result -> getvar( 'nickname' );
		$uid = $result -> getvar( 'uid' );
		$oid = $result -> getvar( 'oid' );
		if ( $uid ) {
				// 已绑定用户
				include SAXUE_ROOT_PATH . "/model/member_users.php";
				$users_handler = &saxuememberusershandler :: getinstance( "saxuememberusershandler" );
				$user = $users_handler -> get( $uid );
				if ( !is_object( $user ) ) {
						// 用户不存在
						saxue_oauth_handle( $oid );
				} else {
						// 登录成功
						del_token(); 
						// 登录次数加1，更新最后登录时间
						$oauth_handler -> updateoauth( $oid ); 
						// 进行登录成功后的用户处理操作
						if ( $user -> getvar( "status", "n" ) != 1 ) {
								saxue_printfail( '您的账户还没有激活！' );
						}
						saxue_oauth_login( $user );
						saxue_jumppage( $_GET['backurl'] );
				} 
		} else {
				// 未绑定用户
				saxue_oauth_handle( $oid );
		}
} else {
		// openid不存在
		$oid = $oauth_handler -> bindopenid( $_GET['site'], $oauth_info );
		if ( !$oid ) {
				// 保存openid失败
				saxue_jumppage( $_GET['backurl'], $saxueOauth[$_GET['site']]['name'] . '帐号OPENID保存失败' );
		} 
		if ( !empty( $_SESSION['saxueUserId'] ) && $_SESSION['saxueUserId'] > 0 ) {
				// 用户已登录，直接绑定
				del_token();
				if ( $oauth_handler -> getoauth( $_SESSION['saxueUserId'], $_GET['site'] ) != false ) {
						saxue_jumppage( '/member/', '您已绑定其他的 ' . $saxueOauth[$_GET['site']]['name'] . ' 帐号，请先解除绑定' );
				} 
				if ( $oauth_handler -> bind( $_SESSION['saxueUserId'], $_GET['site'], $oauth_info ) ) {
						saxue_jumppage( $_GET['backurl'], $saxueOauth[$_GET['site']]['name'] . '帐号绑定成功' );
				} else {
						saxue_jumppage( $_GET['backurl'], $saxueOauth[$_GET['site']]['name'] . '帐号绑定失败' );
				} 
		} else {
				// 用户未登录
				$_SESSION['saxueUserId'] = 0;
				$_SESSION['saxueUserName'] = $oauth_info['nickname'];
				saxue_oauth_handle( $oid );
		} 
} 
saxue_freeresource();
