(function() {
	var DEFAULTS = {
		url: null,
		item: null,
		trigger: null,
		container: null,
		page: 1,
		totalpage: 1,
		loading: '加载中…'
	};

	function ScrollList(opt) {
		opt = this.options = $.extend({}, DEFAULTS, opt);

		this.trigger = opt.trigger;
		if (!this.trigger || !this.trigger.length) return;
		this.savedTriggerText = this.trigger.text();

		this.container = opt.container;
		if (!this.container || !this.container.length) return;

		this.page = opt.page;
		this.totalpage = opt.totalpage;

		this.init();
	}

	ScrollList.prototype = {
		init: function() {
			var _this = this;
			_this.page += 1;
			if (_this.page>_this.totalpage) {
				_this.trigger.hide();
				return false;
			}
			_this.trigger.click(function() {
				if (_this.page>_this.totalpage) {
					_this.trigger.hide();
					return false;
				}
				_this.trigger.text(_this.options.loading);
				if (_this.queryLock) return;
				_this.queryLock = true;
				$.get(_this.options.url.replace('<{$page}>', _this.page), function(data){
					if (data) {
						_this.container.append($(data).find(_this.options.item));
					} else {
						_this.trigger.hide();
					}
				})
				_this.queryLock = false;
				_this.page += 1;
				if (_this.page>_this.totalpage) {
					_this.trigger.hide();
					return false;
				}
				_this.trigger.text(_this.savedTriggerText);
				return false;
			});
		}
	};

	window.ScrollList = ScrollList;
})();