<?php
function saxue_socket_url( $_url ) {
		if ( !function_exists( "fsockopen" ) ) {
				return false;
		}
		$_method = "GET";
		$_arr = parse_url( $_url );
		$_port = isset( $_arr['port'] ) ? $_arr['port'] : 80;
		$_fp = fsockopen( $_arr['host'], $_port, $_errno, $_errstr, 30 );
		if ( !$_fp ) {
				return false;
		}
		$_path = $_arr['path'];
		if ( !empty( $_arr['query'] ) ) {
				$_path .= "?" . $_arr['query'];
		}
		$_str = $_method . " " . $_path;
		$_str .= " HTTP/1.1\r\n";
		$_str .= "Host: " . $_arr['host'] . "\r\n";
		$_str .= "Connection:Close\r\n\r\n";
		fwrite( $_fp, $_str );
		if ( !feof( $_fp ) ) {
				fgets( $_fp, 8 );
		}
		fclose( $_fp );
		return true;
}
if ( !defined( "SAXUE_CORE_INCLUDE" ) ) {
		include "../../core.php";
} 
saxue_checkpower( 'topic' );
$topicid = intval( $_REQUEST['topicid'] );
if ( !$topicid ) {
		saxue_printfail( LANG_ERROR_PARAMETER );
} 
include SAXUE_ROOT_PATH . "/model/topic.php";
$topic_handler = &saxuetopichandler :: getinstance( "saxuetopichandler" );
$topic = $topic_handler -> get( $topicid );
if ( !$topic ) {
		saxue_printfail( '专题不存在' );
} 
if ( empty( $_REQUEST['action'] ) ) $_REQUEST['action'] = 'show';
saxue_getconfigs( "cate", "article" );
saxue_getconfigs( "configs", "article" );
include SAXUE_ROOT_PATH . "/model/article.php";
$article_handler = &saxuearticlehandler :: getinstance( "saxuearticlehandler" );
switch ( $_REQUEST['action'] ) {
		case 'delete':
				if ( empty( $_POST['ids'] ) || !is_array( $_POST['ids'] ) || count( $_POST['ids'] ) == 0 ) {
						exit( json_encode( array( 'flag' => 0, 'msg' => '请选择要删除的文章' ) ) );
				}
				$article_handler -> updatefields( array( 'topicid' => 0 ), 'aid IN(' . implode( ',', $_POST['ids'] ) . ')' );
				$topic_handler -> updatefields( 'counts=counts-' . count( $_POST['ids'] ), 'topicid=' . $topicid );
				//重新生成文章
				if ( $saxueConfigs['article']['url_detail'] > 2 ) {
						saxue_socket_url( SAXUE_URL . '/article/admin/html.php?type=ids&packflag[]=makehtml&packflag[]=makeindex&pc=1&mobile=1&ids=' . implode( ',', $_POST['ids'] ) );
				}
				exit( json_encode( array( 'flag' => 1 ) ) );
				break;
		case 'show':
				$_pagesize = 15;
				if ( empty( $_REQUEST['page'] ) || !is_numeric( $_REQUEST['page'] ) ) $GLOBALS['_REQUEST']['page'] = 1;
				$criteria = new criteriacompo( new criteria( 'topicid', $topicid ) );
				$criteria -> setsort( "aid" );
				$criteria -> setorder( "DESC" );
				$criteria -> setlimit( $_pagesize );
				$criteria -> setstart( ( $_REQUEST['page'] - 1 ) * $_pagesize );
				$article_handler -> queryobjects( $criteria );
				$tables = array();
				while ( $v = $article_handler -> getobject() ) {
						$k = $v -> getvar( 'aid' );
						$rows[$k] = $v -> getvars( 'n' );
						$rows[$k]['cname'] = $saxueCate['article'][$rows[$k]['cid']]['cname'];
						$rows[$k]['curl'] = $saxueCate['article'][$rows[$k]['cid']]['curl'];
						$rows[$k]['pname'] = $saxueCate['article'][$rows[$k]['pid']]['cname'];
						$rows[$k]['purl'] = $saxueCate['article'][$rows[$k]['pid']]['curl'];
						$tables[$rows[$k]['tbnum']][] = $k;
				} 
				foreach ( $tables as $tbnum => $ids  ) {
						$_res = $article_handler -> db -> query( "SELECT * FROM " . saxue_dbprefix( 'article_data_' . $tbnum ) . " WHERE aid IN (" . implode( ',', $ids ) . ")" );
						while ( $v = $article_handler -> getobject( $_res ) ) {
								$k = $v -> getvar( 'aid' );
								$tmp = $rows[$k];
								$rows[$k] = $tmp + ( $v -> getvars( 'n' ) );
						} 
				} 
				include_once( SAXUE_ADMIN_PATH . "/header.php" );
				$saxueTpl -> assign_by_ref( "rows", $rows );
				include_once( SAXUE_ROOT_PATH . "/lib/util/page.php" );
				$jumppage = new saxuepage( $article_handler -> getcount( $criteria ), $_pagesize, $_REQUEST['page'] );
				$jumppage -> setlink( "", true, true );
				$saxueTpl -> assign( "url_jumppage", $jumppage -> whole_bar() );
				$saxueTset['saxue_contents_template'] = SAXUE_WEB_PATH . "/topic/templates/article.html";
				include_once( SAXUE_ADMIN_PATH . "/footer.php" );
				break;
		case 'add':
				if ( isset( $_POST['dosubmit'] ) ) {
						if ( empty( $_POST['ids'] ) || !is_array( $_POST['ids'] ) || count( $_POST['ids'] ) == 0 ) {
								exit( json_encode( array( 'flag' => 0, 'msg' => '请选择要添加的文章' ) ) );
						}
						$article_handler -> updatefields( array( 'topicid' => $topicid ), 'aid IN(' . implode( ',', $_POST['ids'] ) . ')' );
						$topic_handler -> updatefields( 'counts=counts+' . count( $_POST['ids'] ), 'topicid=' . $topicid );
						//重新生成文章
						if ( $saxueConfigs['article']['url_detail'] > 2 ) {
								saxue_socket_url( SAXUE_URL . '/article/admin/html.php?type=ids&packflag[]=makehtml&packflag[]=makeindex&pc=1&mobile=1&ids=' . implode( ',', $_POST['ids'] ) );
						}
						exit( json_encode( array( 'flag' => 1 ) ) );
				}
				$_pagesize = 15;
				if ( empty( $_REQUEST['page'] ) || !is_numeric( $_REQUEST['page'] ) ) $GLOBALS['_REQUEST']['page'] = 1;
				saxue_getconfigs( "datatable", "article" );
				if ( empty( $_REQUEST['tbnum'] ) || !array_key_exists( $_REQUEST['tbnum'], $saxueDatatable['article'] ) ) {
						$_REQUEST['tbnum'] = $saxueConfigs['article']['tbnum'];
				}
				$datatable = $saxueDatatable['article'][$_REQUEST['tbnum']];
				$ids = array();
				$checkids = false;
				if ( !empty( $_REQUEST['keytype'] ) && !empty( $_REQUEST['keyword'] ) && in_array( $_REQUEST['keytype'], array( 'title', 'author' ) ) ) {
						if ( $_REQUEST['searchtype'] == 2 ) {
								$sql = 'SELECT aid FROM ' . $datatable . ' WHERE ' . $_REQUEST['keytype'] . " = '" . $_REQUEST['keyword'] . "'";
						} elseif ( $_REQUEST['searchtype'] == 1 ) {
								$sql = 'SELECT aid FROM ' . $datatable . ' WHERE ' . $_REQUEST['keytype'] . " LIKE '" . $_REQUEST['keyword'] . "%'";
						} else {
								$sql = 'SELECT aid FROM ' . $datatable . ' WHERE ' . $_REQUEST['keytype'] . " LIKE '%" . $_REQUEST['keyword'] . "%'";
						}
						$res = $article_handler -> db -> query( $sql );
						while ( $v = $article_handler -> getobject( $res ) ) {
								$ids[] = $v -> getvar( 'aid' );
						}
						$checkids = true;
				}
				$rows = array();
				if ( !$checkids || count( $ids ) > 0 ) {
						$criteria = new criteriacompo();
						if ( $checkids ) {
								$criteria -> add( new criteria( 'aid', '(' . implode( ',', $ids ) . ')', 'IN' ) );
						}
						if ( !empty( $_REQUEST['cid'] ) ) {
								if ( $saxueCate['article'][$_REQUEST['cid']]['pid'] ) {
										$criteria -> add( new criteria( 'cid', $_REQUEST['cid'] ) );
								} else {
										$criteria -> add( new criteria( 'pid', $_REQUEST['cid'] ) );
								} 
						}
						if ( !$checkids && !empty( $_REQUEST['keytype'] ) && !empty( $_REQUEST['keyword'] ) ) {
								$criteria -> add( new criteria( $_REQUEST['keytype'], intval( $_REQUEST['keyword'] ) ) );
						}
						$criteria -> add( new criteria( 'status', 1 ) );
						$criteria -> add( new criteria( 'tbnum', $_REQUEST['tbnum'] ) );
						if ( isset( $_REQUEST['form_sort'] ) && !empty( $_REQUEST['form_sort'] ) ) {
								$criteria -> setsort( $_REQUEST['form_sort'] );
						} else {
								$criteria -> setsort( "aid" );
						} 
						if ( isset( $_REQUEST['form_order'] ) && !empty( $_REQUEST['form_order'] ) ) {
								$criteria -> setorder( $_REQUEST['form_order'] );
						} else {
								$criteria -> setorder( "DESC" );
						} 
						$criteria -> setlimit( $_pagesize );
						$criteria -> setstart( ( $_REQUEST['page'] - 1 ) * $_pagesize );
						$article_handler -> queryobjects( $criteria );
						$aids = array();
						while ( $v = $article_handler -> getobject() ) {
								$k = $v -> getvar( 'aid' );
								$aids[] = $k;
								$rows[$k] = $v -> getvars( 'n' );
								$rows[$k]['cname'] = $saxueCate['article'][$rows[$k]['cid']]['cname'];
								$rows[$k]['curl'] = $saxueCate['article'][$rows[$k]['cid']]['curl'];
								$rows[$k]['pname'] = $saxueCate['article'][$rows[$k]['pid']]['cname'];
								$rows[$k]['purl'] = $saxueCate['article'][$rows[$k]['pid']]['curl'];
						}  
						if ( count( $aids ) > 0 ) {
								$res = $article_handler -> db -> query( "SELECT * FROM " . $datatable . " WHERE aid IN (" . implode( ',', $aids ) . ")" );
								while ( $v = $article_handler -> getobject( $res ) ) {
										$k = $v -> getvar( 'aid' );
										$rows[$k] = $rows[$k] + ( $v -> getvars( 'n' ) );
								}
						}
						$listrows = $article_handler -> getcount( $criteria );
				} else {
						$listrows = 0;
				}
				include_once( SAXUE_ADMIN_PATH . "/header.php" );
				$saxueTpl -> assign_by_ref( "rows", $rows );
				$saxueTpl -> assign_by_ref( "tables", $saxueDatatable['article'] );
				include_once( SAXUE_ROOT_PATH . "/lib/util/page.php" );
				$jumppage = new saxuepage( $listrows, $_pagesize, $_REQUEST['page'], 5 );
				$jumppage -> setlink( "", true, true );
				$saxueTpl -> assign( "url_jumppage", $jumppage -> whole_bar() );
				include_once( SAXUE_ROOT_PATH . "/lib/util/tree.php" );
				$tree = new tree;
				$tree -> icon = array( '&nbsp;<span class="f_tree">│</span>&nbsp;', '&nbsp;<span class="f_tree">├─</span> ', '&nbsp;<span class="f_tree">└─</span> ' );
				$tree -> nbsp = '&nbsp;';
				$tree -> mid = 'cid';
				$tree -> pid = 'pid';
				$tree -> init( $saxueCate['article'] );
				$str = "<option value=\$cid \$selected>\$spacer\$cname</option>";
				$cates = $tree -> get_tree( 0, $str, intval( $_REQUEST['cid'] ) );
				$saxueTpl -> assign( "cates", $cates );
				$saxueTset['saxue_contents_template'] = SAXUE_WEB_PATH . "/topic/templates/article_add.html";
				include_once( SAXUE_ADMIN_PATH . "/footer.php" );
				break;
} 
