<?php

/**
 *--------------------------------------
 * admin common function library
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-06-28
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

function get_limitPermission($parse = false) {
	/* localhost or licenced LOGA is not limit */
	$_licence = function_exists('get_licence') ? get_licence() : null;
	if('127.0.0.1' == CLIENT_IP or !empty($_licence)) {
		return array('_none');
	}

	$_LP = array();
	$_t_lp = unserialize(ACrypt::decrypt('83d4V5ItbcVJ5fl64JpCq8iRwnTKa5PItWM5qxFfNgpAvKw/wR8YNkNKXLOiloh3CPiB8doQiaWG4P81wbuYL4qqX8fiQ6MmTr8J0DkUBxiCs69EexhIhXJHBlZTjfUIxp+Tkjjffkb0hXLc4XBEjK0j2nQB3dgx4SJ6v2MqbkTUcrdBeBvexzmmKaFeIqMoeQQWQ+Ki9ta481LKqI886kzMmZjVQKBwsyZ/Aqqa1nLw9yoQ1nUsYLSN2pmN+oTidME9DdRDnSORCS9/7monwdD1Epip0/3xSunLwC0NaY6y43w9kTU5v/qUkpl1zd8uIyDIMarvXOAsBTS/U+Pq0I8Nb9pnA31NeBtE1PXxAVKH5I5qNBVvdOaQtEdDr6/DBdh0hV3jJecXFF9taQVId/CZO30agSHxcpb50wNfDsvcNyBwotX0QtoqGO/z9y82MUnhowxb+2cri/lOxCXKU8Gq0/wT9HiIEZJ8wZzJMVIXxDwYg9INmdN89P4Y8cTTLp3uSk/PGMMdbYBUv061c+aCjBQhdVk0jI+FYLjXEYHo7R7gnz+tUxTKRaCzNCvTnJcM2B8cj07LxP87x8AvqwzxiYOCZ9d+6KztN2BZAQc+mMqgqZ3sMN+CFc/MYG4f3rvuTydn/R4jW2M1O1bsUQkvm/6otKwKu77MYXb5mZBF7rpAusuQQtyaniK5/zugcZcBpD/tVoO1SbI6e7IC9ap31hkokkrw8J+4qa7q/IHX9n+YxsjCqy2x9GUWMpQ7RWFxMeZiR9l8/EfLOEQOpMY1BgMQbTmrkBbNyWyFIGoY+FbJrFA6X3M5gliygOH9Ay/7jscsWWMjL+aQ6N2vJoUX1XzFyheAlV3ZleDt7shKTjvZyWPPGBZ2RCgfYMC9yfN7jnfQSD+Npo3MYk71pA8vFF1Z2HEv8WBTP1UoqVjMeUZPGMYcBCtbypotuWBDrFMydPk6UICiZrq19yy9a7xHjLZZPD0UCQY', SOFT_NAME));
	if('yes' != $_t_lp['v']) {
		return array('_all');
	}
	foreach($_t_lp['p'] as $ap) {
		if($parse and strpos($ap, ':')) {
			$_p = explode(':', $ap);
			$_LP[] = parse_name($_p[0]).'/'.$_p[1];
		}
		else {
			$_LP[] = $ap;
		}
	}
	return $_LP;
}

/* get controller list from path */
function get_ctrlrList($ctrlrPath) {
	$names = include_cache($ctrlrPath.'/_names.php');
	$ctrlrList = array();
	$dirRes = opendir($ctrlrPath);
	while($dir = readdir($dirRes)) {
		if(!in_array($dir, array(
			'.',
			'..',
			'index.html',
			'_names.php',
			'.svn'))) {
			$ctrlr = basename($dir, 'Ctrlr.class.php');
			$name = isset($names[$ctrlr]) ? $names[$ctrlr] : $ctrlr;
			$ctrlrList[] = array('ctrlr' => $ctrlr, 'name' => $name);
		}
	}
	return $ctrlrList;
}

/* get action list from controller */
function get_actnList($ctrlr) {
	$ctrlrClass = $ctrlr.'Ctrlr';
	$baseCtrlr = get_class_methods('Ctrlr');
	$advCtrlr = get_class_methods($ctrlrClass);
	$actnList = array_diff($advCtrlr, $baseCtrlr);
	return $actnList;
}

/* get action list from file */
function get_fileActnList($file) {
	$arr = file($file);
	foreach($arr as $line) {
		if(preg_match('/function ([_A-Za-z0-9]+)/i', $line, $regs)) {
			$arr_methods[] = $regs[1];
		}
	}
	return $arr_methods;
}

/* get child directory list, $exclude: exclude dir */
function list_dir($dir, $exclude = array()) {
	$items = array();

	if(empty($dir)) {
		return $items;
	}

	$files = glob(rtrim($dir, '/\\').D_S.'*');
	if(is_array($files)) {
		$names = include_cache($dir.'/_names.php');
		foreach($files as $v) {
			if(is_file($v) or in_array(basename($v), $exclude)) {
				continue;
			}
			$v = basename($v);
			$n = isset($names[$v]) ? $names[$v] : $v;
			$items[] = array('dir' => $v, 'name' => $n);
		}
	}
	return $items;
}

/* get child file list, $exclude: exclude file */
function list_file($dir, $exclude = array('_names.php')) {
	$items = array();

	if(empty($dir)) {
		return $items;
	}

	$files = glob(rtrim($dir, '/\\').D_S.'*');
	if(is_array($files)) {
		$names = include_cache($dir.'/_names.php');
		foreach($files as $v) {
			if(!is_file($v) or in_array(basename($v), $exclude)) {
				continue;
			}
			$v = basename($v);
			$n = isset($names[$v]) ? $names[$v] : $v;
			$items[] = array('file' => $v, 'name' => $n);
		}
	}
	return $items;
}

/* save extension option $extensionAlias */
function edit_extensionOption($extensionAlias, $option) {
	if(MAGIC_QUOTES_GPC) {
		$option = stripslashes_array($option);
	}
	if(C('URL.LANG_SUFFIX')) {
		unset($option[C('VAR.LANG')]);
	}

	$cfgFile = CFG_PATH.D_S.'Extension'.D_S.parse_name($extensionAlias, 1).'.php';

	$_O = include($cfgFile);
	$_O = empty($_O) ? $option : array_merge($_O, $option);

	$content = "<?php\r\n".PFA_ACCESS_CHECK."return ".var_export($_O, true).";\r\n?>";

	return @file_put_contents($cfgFile, $content);
}

?>