<?php

/**
 *--------------------------------------
 * article
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ArticleCtrlr extends ManageCtrlr {
	public function list_article() {
		$where = array();
		$articleCategoryId = ARequest::get('article_category_id') ? ARequest::get('article_category_id') : 0;
		$this->assign('AC_ID', $articleCategoryId);

		/* all category list */
		$_ACL = M('ArticleCategory')->get_categoryList();
		$act = new ATree($_ACL, array('article_category_id', 'ac_parent_id', 'ac_sub_category'));
		$_ACLStr = $act->get_leafStr(0, "<option value='\$article_category_id'>\$spacer \$ac_name</option>\r\n", ARequest::get('article_category_id'), "<option value='\$article_category_id' selected='selected'>\$spacer \$ac_name</option>\r\n");
		$this->assign('_ACLStr', $_ACLStr);

		/* filter category */
		if(!empty($_ACL)) {
			$_t_acid = $act->get_leafid($articleCategoryId);
		}
		$where['__ARTICLE__.article_category_id'] = array('IN', $_t_acid);

		$_AFL = EO('article_flag');
		$this->assign('_AFL', $_AFL);

		/* filter flag */
		$afAlias = ARequest::get('af_alias') ? ARequest::get('af_alias') : '';
		if(!empty($afAlias)) {
			$where['__ARTICLE__.af_alias'] = array('INSET', $afAlias);
		}

		/* filter status */
		$aStatus = ARequest::get('a_status') ? ARequest::get('a_status') : '';
		if('n' == $aStatus) {
			$where['__ARTICLE__.a_status'] = array('EQ', 0);
		}
		elseif('p' == $aStatus) {
			$where['__ARTICLE__.a_status'] = array('EQ', 1);
		}
		elseif('r' == $aStatus) {
			$where['__ARTICLE__.a_status'] = array('EQ', 2);
		}

		/* filter title */
		$aTitle = ARequest::get('a_title');
		if(!empty($aTitle)) {
			$where['__ARTICLE__.a_title'] = array('LIKE', '%'.$aTitle.'%');
		}

		/* get paging and list */
		$_PG = '';
		$_AL = '';
		$rowsNum = M('Article')->get_articleCount($where);
		if(0 < $rowsNum) {
			$orderBy = array_key_exists(ARequest::get('order_by'), $_SF) ? ARequest::get('order_by') : '';
			$orderTurn = in_array(ARequest::get('order_turn'), array('desc', 'asc')) ? ARequest::get('order_turn') : '';
			$pageSize = (ARequest::get('page_size') > 0 ? ARequest::get('page_size') : 20);
			$p = new APage($rowsNum, $pageSize, Url::U('article/list_article?article_category_id='.$articleCategoryId.'&a_status='.$aStatus.'&a_title='.$aTitle.'&page_size='.$pageSize.'&'.C('VAR.PAGE').'=_page_'));
			$_PG = $p->get_paging();

			$order = !empty($orderBy) ? "`{$orderBy}` ".(!empty($orderTurn) ? " {$orderTurn}" : '') : '`a_rank` DESC, `a_edit_time` DESC';
			$_AL = M('Article')->get_articleList($where, $order, $p->get_limit());
		}
		$this->assign('_PG', $_PG);
		$this->assign('_AL', $_AL);

		$this->display('article/list_article');
	}

	/* add article */
	public function add_article() {
		$articleCategoryId = ARequest::get('article_category_id');
		$_ACI = M('ArticleCategory')->get_categoryInfo($articleCategoryId);
		$_ACI['a_tpl'] = $_ACI['ac_a_tpl'];
		if(empty($_ACI['a_tpl'])) {
			$_ACI['a_tpl'] = 'show_article.php';
		}
		$this->assign('_AI', $_ACI);

		/* flag list */
		$_AFL = EO('article_flag');
		$this->assign('_AFL', $_AFL);

		// template list
		$_C = require (CFG_PATH.D_S.'comm.php');
		$_TPLS = list_file(C('TE.TPL_PATH').D_S.$_C['TE']['TPL_THEME'].D_S.'home');
		$this->assign('_TPLS', $_TPLS);

		$this->display('article/add_article');
	}
	public function add_article_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$data['af_alias'] = (!empty($data['af_alias']) ? implode(',', $data['af_alias']) : '');
		$data['a_add_time'] = NOW_TIME;
		$data['a_edit_time'] = !empty($data['a_edit_time']) ? strtotime($data['a_edit_time']) : NOW_TIME;
		$data['a_add_ip'] = CLIENT_IP;
		$data['a_edit_ip'] = $data['a_add_ip'];

		if('yes' == $data['delete_external_links']) {
			if(MAGIC_QUOTES_GPC) {
				$data['a_content'] = stripslashes($data['a_content']);
			}
			$data['a_content'] = str_replace(__HOST__, '#basehost#', $data['a_content']);
			$data['a_content'] = preg_replace("/(<a[ \t\r\n]{1,}href=[\"']{0,}http:\/\/[^\/]([^>]*)>)|(<\/a>)/isU", '', $data['a_content']);
			$data['a_content'] = str_replace('#basehost#', __HOST__, $data['a_content']);
			if(MAGIC_QUOTES_GPC) {
				$data['a_content'] = addslashes($data['a_content']);
			}
			unset($data['delete_external_links']);
		}

		/* deal with meta */
		$data['a_title'] = AFilter::plain_text($data['a_title']);
		$data['a_keywords'] = AFilter::plain_text($data['a_keywords']);
		/* get abstract */
		if('yes' == $data['get_abstract']) {
			$data['a_description'] = AFilter::plain_text(strip_tags($data['a_content']), 200);
			unset($data['get_abstract']);
		}
		else {
			$data['a_description'] = AFilter::plain_text($data['a_description']);
		}

		/* insert into main table */
		$result = M('Article')->add_article($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_ARTICLE').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('article/list_article?article_category_id='.$data['article_category_id']));
		}

		M('Log')->add_log(L('ADD_ARTICLE').': ID['.$result['data'].']');
		$this->success(L('ADD_SUCCESS'), Url::U('article/list_article?article_category_id='.$data['article_category_id']));
	}

	/* edit article */
	public function edit_article() {
		$articleId = ARequest::get('article_id');
		$_AI = M('Article')->get_articleInfo($articleId);
		if(empty($_AI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('article/list_article'));
		}
		$this->assign('_AI', $_AI);

		/* flag list */
		$_AFL = EO('article_flag');
		$this->assign('_AFL', $_AFL);

		// template list
		$_C = require (CFG_PATH.D_S.'comm.php');
		$_TPLS = list_file(C('TE.TPL_PATH').D_S.$_C['TE']['TPL_THEME'].D_S.'home');
		$this->assign('_TPLS', $_TPLS);

		$this->display('article/edit_article');
	}
	public function edit_article_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$_AI = M('Article')->field('article_id')->where(array('article_id' => array('EQ', ARequest::get('article_id'))))->find();
		if(empty($_AI)) {
			M('Log')->add_log(L('EDIT_ARTICLE').': ID['.$data['article_id'].']'.L('ITEM_INEXISTENCE'), 0);
			$this->error(L('ITEM_INEXISTENCE'), Url::U('article/list_article'));
		}

		$data['af_alias'] = (!empty($data['af_alias']) ? implode(',', $data['af_alias']) : '');
		if(isset($data['not_upodate_edit_time']) and 'n' == strtolower($data['not_upodate_edit_time'])) {
			unset($data['a_edit_time']);
		}
		else {
			$data['a_edit_time'] = !empty($data['a_edit_time']) ? strtotime($data['a_edit_time']) : NOW_TIME;
		}
		$data['a_edit_ip'] = CLIENT_IP;

		if('yes' == $data['delete_external_links']) {
			if(MAGIC_QUOTES_GPC) {
				$data['a_content'] = stripslashes($data['a_content']);
			}
			$data['a_content'] = str_replace(__HOST__, '#basehost#', $data['a_content']);
			$data['a_content'] = preg_replace("/(<a[ \t\r\n]{1,}href=[\"']{0,}http:\/\/[^\/]([^>]*)>)|(<\/a>)/isU", '', $data['a_content']);
			$data['a_content'] = str_replace('#basehost#', __HOST__, $data['a_content']);
			if(MAGIC_QUOTES_GPC) {
				$data['a_content'] = addslashes($data['a_content']);
			}
			unset($data['delete_external_links']);
		}

		/* deal with meta */
		$data['a_title'] = AFilter::plain_text($data['a_title']);
		$data['a_keywords'] = AFilter::plain_text($data['a_keywords']);
		/* get abstract */
		if('yes' == $data['get_abstract']) {
			$data['a_description'] = AFilter::plain_text(strip_tags($data['a_content']), 200);
			unset($data['get_abstract']);
		}
		else {
			$data['a_description'] = AFilter::plain_text($data['a_description']);
		}

		/* edit main table data */
		$result = M('Article')->edit_article($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_ARTICLE').': ID['.$data['article_id'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('article/list_article?article_category_id='.$data['article_category_id']));
		}

		M('Log')->add_log(L('EDIT_ARTICLE').': ID['.$data['article_id'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('article/list_article?article_category_id='.$data['article_category_id']));
	}

	public function update_count_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$articleId = ARequest::get('article_id');
		$articleId = is_array($articleId) ? $articleId : explode(',', $articleId);
		$_L_ID = implode(', ', $articleId);

		foreach($articleId as $articleId) {
			$result = M('Article')->update_count($articleId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('UPDATE_ARTICLE_COUNT').': ID['.$articleId.']'.$result['error'], 0);
				$this->error($result['error'], AServer::get_preUrl());
			}
		}

		M('Log')->add_log(L('UPDATE_ARTICLE_COUNT').': ID['.$_L_ID.']');
		$this->success(L('UPDATE_SUCCESS'), AServer::get_preUrl());
	}

	/* delete article */
	public function delete_article_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$articleId = ARequest::get('article_id');
		$articleId = is_array($articleId) ? $articleId : explode(',', $articleId);
		$_L_ID = implode(', ', $articleId);

		foreach($articleId as $articleId) {
			$result = M('Article')->delete_article($articleId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_ARTICLE').': ID['.$articleId.']'.$result['error'], 0);
				$this->error($result['error'], AServer::get_preUrl());
			}
		}

		M('Log')->add_log(L('DELETE_ARTICLE').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), AServer::get_preUrl());
	}

	/* change category */
	public function change_category_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$articleId = ARequest::get('article_id');
		$articleCategoryId = ARequest::get('article_category_id');
		$_L_ID = is_array($articleId) ? implode(', ', $articleId) : $articleId;

		if(empty($articleCategoryId) or empty($articleId)) {
			M('Log')->add_log(L('EDIT_ARTICLE').': ID['.$articleId.']'.L('PARAMS_ERROR'), 0);
			$this->error(L('PARAMS_ERROR'), AServer::get_preUrl());
		}

		$articleId = explode(',', $articleId);
		foreach($articleId as $articleId) {
			$_AI = M('Article')->field('a_title')->where(array('article_id' => array('EQ', $articleId)))->find();
			if(empty($_AI)) {
				M('Log')->add_log(L('EDIT_ARTICLE').': ID['.$articleId.']'.L('ITEM_INEXISTENCE'), 0);
				$this->error(L('ITEM_INEXISTENCE'), AServer::get_preUrl());
			}

			$data['article_category_id'] = $articleCategoryId;
			$data['article_id'] = $articleId;
			$result = M('Article')->edit_article($data);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('EDIT_ARTICLE').': ID['.$articleId.']'.$result['error'], 0);
				$this->error($result['error'], AServer::get_preUrl());
			}
		}

		M('Log')->add_log(L('EDIT_ARTICLE').': ID['.$_L_ID.']');
		$this->success(L('EDIT_SUCCESS'), AServer::get_preUrl());
	}

	/* add flag */
	public function add_flag_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$articleId = ARequest::get('article_id');
		$afALias = ARequest::get('af_alias');
		$_L_ID = is_array($articleId) ? implode(', ', $articleId) : $articleId;

		if(empty($afALias) or empty($articleId)) {
			M('Log')->add_log(L('ADD_ARTICLE_FLAG').': ID['.$articleId.']'.L('PARAMS_ERROR'), 0);
			$this->error(L('PARAMS_ERROR'), AServer::get_preUrl());
		}

		$articleId = explode(',', $articleId);
		foreach($articleId as $articleId) {
			$_AI = M('Article')->field('a_title')->where(array('article_id' => array('EQ', $articleId)))->find();
			if(empty($_AI)) {
				M('Log')->add_log(L('ADD_ARTICLE_FLAG').': ID['.$articleId.']'.L('ITEM_INEXISTENCE'), 0);
				$this->error(L('ITEM_INEXISTENCE'), AServer::get_preUrl());
			}

			$result = M('Article')->add_flag($articleId, $afALias);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('ADD_ARTICLE_FLAG').': ID['.$articleId.']'.$result['error'], 0);
				$this->error($result['error'], AServer::get_preUrl());
			}
		}

		M('Log')->add_log(L('ADD_ARTICLE_FLAG').': ID['.$_L_ID.']');
		$this->success(L('ADD_FLAG_SUCCESS'), AServer::get_preUrl());
	}

	/* delete flag */
	public function delete_flag_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$articleId = ARequest::get('article_id');
		$afALias = ARequest::get('af_alias');
		$_L_ID = is_array($articleId) ? implode(', ', $articleId) : $articleId;

		if(empty($afALias) or empty($articleId)) {
			M('Log')->add_log(L('DELETE_ARTICLE_FLAG').': ID['.$articleId.']'.L('PARAMS_ERROR'), 0);
			$this->error(L('PARAMS_ERROR'), AServer::get_preUrl());
		}

		$articleId = explode(',', $articleId);
		foreach($articleId as $articleId) {
			$_AI = M('Article')->field('a_title')->where(array('article_id' => array('EQ', $articleId)))->find();
			if(empty($_AI)) {
				M('Log')->add_log(L('DELETE_ARTICLE_FLAG').': ID['.$articleId.']'.L('ITEM_INEXISTENCE'), 0);
				$this->error(L('ITEM_INEXISTENCE'), AServer::get_preUrl());
			}

			$result = M('Article')->delete_flag($articleId, $afALias);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_ARTICLE_FLAG').': ID['.$articleId.']'.$result['error'], 0);
				$this->error($result['error'], AServer::get_preUrl());
			}
		}

		M('Log')->add_log(L('DELETE_ARTICLE_FLAG').': ID['.$_L_ID.']');
		$this->success(L('DELETE_FLAG_SUCCESS'), AServer::get_preUrl());
	}

}

?>