<?php

/**
 *--------------------------------------
 * ban IP
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-05
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class BanIpCtrlr extends ManageCtrlr {
	public function list_ip() {
		$_BIL = M('BanIp')->get_ipList();
		$this->assign('_BIL', $_BIL);

		$this->display('ban_ip/list_ip');
	}

	public function add_ip() {
		$this->display('ban_ip/add_ip');
	}
	public function add_ip_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		if(isset($data['expire_not_limit'])) {
			$data['bi_expire_time'] = 0;
		}
		else {
			unset($data['expire_not_limit']);
			$data['bi_expire_time'] = strtotime($data['bi_expire_time']);
		}
		$data['bi_add_time'] = NOW_TIME;
		$data['bi_note'] = AFilter::text($data['bi_note']);

		$result = M('BanIp')->add_ip($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_BAN_IP').': WORD['.$data['il_word'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('ban_ip/list_ip'));
		}
		M('Log')->add_log(L('ADD_BAN_IP').': WORD['.$data['il_word'].']');
		$this->success(L('ADD_SUCCESS'), Url::U('ban_ip/list_ip'));
	}

	public function edit_ip() {
		$banIpId = ARequest::get('ban_ip_id');

		$_BII = M('BanIp')->get_ipInfo($banIpId);
		if(empty($_BII)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('ban_ip/list_ip'));
		}
		$this->assign('_BII', $_BII);

		$this->display('ban_ip/edit_ip');
	}
	public function edit_ip_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		if(isset($data['expire_not_limit'])) {
			$data['bi_expire_time'] = 0;
		}
		else {
			unset($data['expire_not_limit']);
			$data['bi_expire_time'] = strtotime($data['bi_expire_time']);
		}
		$data['bi_note'] = AFilter::text($data['bi_note']);

		$result = M('BanIp')->edit_ip($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_BAN_IP').': WORD['.$data['il_word'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('ban_ip/list_ip'));
		}
		M('Log')->add_log(L('EDIT_BAN_IP').': WORD['.$data['il_word'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('ban_ip/list_ip'));
	}

	public function delete_ip_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$banIpId = ARequest::get('ban_ip_id');
		$banIpId = is_array($banIpId) ? $banIpId : explode(',', $banIpId);
		$_L_ID = implode(', ', $banIpId);

		foreach($banIpId as $banIpId) {
			$result = M('BanIp')->delete_ip($banIpId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_BAN_IP').': ID['.$banIpId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('ban_ip/list_ip'));
			}
		}

		M('Log')->add_log(L('DELETE_BAN_IP').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('ban_ip/list_ip'));
	}

	public function clear_expired_ip_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$result = M('BanIp')->clear_expiredIp();
		if(!empty($result['error'])) {
			M('Log')->add_log(L('CLEAR_EXPIRED_BAN_IP').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('ban_ip/list_ip'));
		}

		M('Log')->add_log(L('CLEAR_EXPIRED_BAN_IP'));
		$this->success(L('CLEAR_SUCCESS'), Url::U('ban_ip/list_ip'));
	}

}

?>