<?php

/**
 *--------------------------------------
 * cache
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-01
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class CacheCtrlr extends ManageCtrlr {
	public function clear_cache() {
		$nextUrl = F('_cache_next_url', '', RUNTIME_PATH);
		$this->assign('nextUrl', $nextUrl);

		$this->display('cache/clear_cache');
	}
	public function clear_cache_do() {
		$type = F('_clear_cache_type', '', RUNTIME_PATH);
		$typeCount = F('_clear_cache_type_count', '', RUNTIME_PATH);
		if(empty($type)) {
			$type = ARequest::get('type');
			$type = is_array($type) ? $type : explode(',', $type);
			$_L_ID = implode(', ', $type);

			if(empty($type)) {
				$this->error(L('INPUT_NO_EMPTY'), Url::U('cache/clear_cache'));
			}
			$type[] = '_end_';
			F('_clear_cache_type', $type, RUNTIME_PATH);
			F('_clear_cache_type_count', count($type), RUNTIME_PATH);
		}

		set_time_limit(99999999);
		$this->display('cache/progress');

		$limit = 20;
		$_type = $type[0];
		if(in_array($_type, array('runtime', 'cache', 'data', 'temp'))) {
			if('runtime' == $_type) {
				$_result = array(
					'finish' => true,
					'error' => @unlink(RUNTIME_PATH.D_S.'_runtime.php')
				);
			}
			elseif('cache' == $_type) {
				$_result = $this->_clear_dir(CACHE_PATH, $limit);
			}
			elseif('data' == $_type) {
				$_result = $this->_clear_dir(DATA_PATH, $limit);
			}
			elseif('temp' == $_type) {
				if('File' == C('CACHE.TYPE')) {
					// just clear temp data of home group
					$_result = $this->_clear_dir(TEMP_PATH.D_S.'home', $limit);
				}
				else {
					$cache = Cache::connect();
					$_result = array(
						'finish' => true,
						'error' => $cache->clear()
					);
				}
			}

			if(!empty($_result['error'])) {
				F('_clear_cache_type', null, RUNTIME_PATH);
				M('Log')->add_log(L('CLEAR_CACHE').': TYPE['.$_type.']'.$_result['error'], 0);
			}

			if($_result['finish']) {
				array_shift($type);
				F('_clear_cache_type', $type, RUNTIME_PATH);
				M('Log')->add_log(L('CLEAR_CACHE').': TYPE['.$_type.']');
			}

			$nextUrl = Url::U('cache/clear_cache_do');
			F('_cache_next_url', $nextUrl, RUNTIME_PATH);

			$progress = round(($typeCount - count($type)) / $typeCount * 100, 1);
			M('Cache')->show_progress($progress.'%['.$_type.']: '.$_result['dirname'], $progress);
			M('Cache')->show_direction($nextUrl);
		}
		else {
			F('_clear_cache_type', null, RUNTIME_PATH);
			F('_clear_cache_type_count', null, RUNTIME_PATH);
			F('_cache_next_url', null, RUNTIME_PATH);
			M('Cache')->show_progress(L('CLEAR_CACHE_COMPLETE'), 100);
			set_time_limit(30);
			M('Cache')->show_direction(Url::U('cache/clear_cache'), true, 1);
		}
	}

	/* clear file in dir. $limit:items of each time; $issub: is sub dir */
	private function _clear_dir($dir, $limit = 0, $issub = false) {
		$dirname = addslashes(str_replace(RUNTIME_PATH, '', $dir));

		if(!is_dir($dir)) {
			return array('dirname' => $dirname, 'finish' => true, 'error' => L('DIR_INEXISTENCE', null, array('dir' => $dirname)));
		}
		if(false == ($handle = @opendir($dir))) {
			return array('dirname' => $dirname, 'finish' => true, 'error' => L('OPEN_DIR_HANDLE_FAILED', null, array('dir' => $dirname)));
		}

		N('file_delete_limit', null);
		while(($file = readdir($handle)) !== false) {
			if('.' == $file || '..' == $file || ('index.html' == $file and !$issub)) {
				continue;
			}
			$path = realpath("$dir/$file");
			if(is_dir($path)) {
				$result = $this->_clear_dir("$dir/$file", $limit, true);
				if(!empty($result['error']) or $result['finish']) {
					return $result;
				}
			}
			else {
				if($limit > 0 and N('file_delete_limit') == $limit) {
					return array('dirname' => $dirname, 'finish' => false, 'error' => '');
				}

				N('file_delete_limit', 1);
				if(!@unlink($path)) {
					return array('dirname' => $dirname, 'finish' => true, 'error' => L('DELETE_FILE_FAILED', null, array('file' => $dirname)));
				}
			}
		}
		if(readdir($handle) === false) {
			closedir($handle);

			if($issub) {
				if(!@rmdir($dir)) {
					return array('dirname' => $dirname, 'finish' => true, 'error' => L('DELETE_DIR_FAILED', null, array('dir' => $dirname)));
				}
				return array('dirname' => $dirname, 'finish' => false, 'error' => '');
			}
			else {
				return array('dirname' => $dirname, 'finish' => true, 'error' => '');
			}
		}
	}

}

?>