<?php

/**
 *--------------------------------------
 * common
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-06-25
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class CommonCtrlr extends Ctrlr {
	public function __construct() {
		parent::__construct();

		/* check entry */
		session_start();
		if(!isset($_SESSION['admin_enter']) or 1 != $_SESSION['admin_enter']) {
			redirect(Url::U('home@index/index'));
			exit();
		}
	}

	public function _captcha_img() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$name = in_array(ARequest::get('name'), array('vcode', 'test')) ? ARequest::get('name', 'get') : 'vcode';

		$fonts = array(
			'spacing' => 2,
			'size' => 16,
			'font' => RES_PATH.D_S.'font/font.ttf');
		$ac = new ACaptcha(90, 30, 5, $fonts);
		ASession::set($name, strtolower($ac->text));
		$ac->create_image();
	}

	public function _toggle_lang() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$lang = strtolower(ARequest::get(C('VAR.LANG')));
		$langset = get_langset();

		$url = Url::U('admin@index/index');

		if(empty($lang) or !array_key_exists($lang, $langset)) {
			if(IS_AJAX) {
				$this->ajax_return(array('data' => 0));
			}
			redirect($url);
		}

		ACookie::set('lang', $lang);

		if(IS_AJAX) {
			$this->ajax_return(array('data' => 1));
		}
		redirect($url);
	}

	/* get action list of controller */
	public function _get_actn_list() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$ctrlr = ARequest::get('ctrlr');
		$actnList = get_actnList($ctrlr);
		$this->ajax_return(array('data' => $actnList));
	}
}

?>