<?php

/**
 *--------------------------------------
 * guestbook
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class GuestbookCtrlr extends ManageCtrlr {
	public function edit_option() {
		$this->assign('_O', EO('guestbook'));

		$this->display('guestbook/edit_option');
	}
	public function edit_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		unset($data['timeKey']);
		unset($data['token']);

		if(!edit_extensionOption('guestbook', $data)) {
			M('Log')->add_log(L('EDIT_GUESTBOOK_OPTION').': '.L('SAVE_CFG_FILE_FAILED'), 0);
			$this->error(L('SAVE_CFG_FILE_FAILED'), Url::U('guestbook/edit_option'));
		}
		M('Log')->add_log(L('EDIT_GUESTBOOK_OPTION'));
		$this->success(L('EDIT_SUCCESS'), Url::U('guestbook/edit_option'));
	}

	public function list_guestbook() {
		$where = array();

		/* filter public */
		$gPrivate = ARequest::get('g_private') ? ARequest::get('g_private') : '';
		if('y' == $gPrivate) {
			$where['__GUESTBOOK__.g_password'] = array('NEQ', '');
		}
		elseif('n' == $Private) {
			$where['__GUESTBOOK__.g_password'] = array('EQ', '');
		}

		/* filter reply */
		$gReply = ARequest::get('g_reply') ? ARequest::get('g_reply') : '';
		if('y' == $gReply) {
			$where['__GUESTBOOK__.g_reply'] = array('NEQ', '');
		}
		elseif('n' == $gReply) {
			$where['__GUESTBOOK__.g_reply'] = array('EQ', '');
		}

		/* filter status */
		$gStatus = ARequest::get('g_status') ? ARequest::get('g_status') : '';
		if('n' == $gStatus) {
			$where['__GUESTBOOK__.g_status'] = array('EQ', 0);
		}
		elseif('p' == $gStatus) {
			$where['__GUESTBOOK__.g_status'] = array('EQ', 1);
		}
		elseif('f' == $gStatus) {
			$where['__GUESTBOOK__.g_status'] = array('EQ', 2);
		}

		/* filter content */
		$gContent = ARequest::get('g_content');
		if(!empty($gContent)) {
			$where['__GUESTBOOK__.g_content'] = array('LIKE', '%'.$gContent.'%');
		}

		/* get paging and list */
		$_PG = '';
		$_GL = '';
		$rowsNum = M('Guestbook')->where($where)->count();
		if(0 < $rowsNum) {
			$orderBy = ARequest::get('order_by') ? ARequest::get('order_by') : 'guestbook_id';
			$orderTurn = ARequest::get('order_turn') ? ARequest::get('order_turn') : 'desc';
			$pageSize = (ARequest::get('page_size') > 0 ? ARequest::get('page_size') : 20);
			$p = new APage($rowsNum, $pageSize, Url::U('guestbook/list_guestbook?g_private='.$gPrivate.'&g_reply='.$gReply.'&g_status='.$gStatus.'&g_content='.$gContent.'&order_by='.$orderBy.'&order_turn='.$orderTurn.'&page_size='.$pageSize.'&'.C('VAR.PAGE').'=_page_'));
			$_PG = $p->get_paging();

			$_GL = M('Guestbook')->get_guestbookList($where, "`{$orderBy}` {$orderTurn}", $p->get_limit(), false);
		}
		$this->assign('_PG', $_PG);
		$this->assign('_GL', $_GL);

		$this->display('guestbook/list_guestbook');
	}

	public function edit_guestbook() {
		$guestbookId = ARequest::get('guestbook_id');
		$_GI = M('Guestbook')->get_guestbookInfo($guestbookId, true);
		if(empty($_GI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('guestbook/list_guestbook'));
		}
		$this->assign('_GI', $_GI);

		$this->display('guestbook/edit_guestbook');
	}
	public function edit_guestbook_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		if(!empty($data['g_reply'])) {
			$data['g_reply_time'] = NOW_TIME;
		}
		$data['g_content'] = str_replace(array("\r\n", "\n"), "<br />", AFilter::text($data['g_content']));
		$data['g_reply'] = str_replace(array("\r\n", "\n"), "<br />", AFilter::text($data['g_reply']));

		$result = M('Guestbook')->edit_guestbook($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_GUESTBOOK').': ID['.$data['guestbook_id'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('guestbook/list_guestbook'));
		}
		M('Log')->add_log(L('EDIT_GUESTBOOK').': ID['.$data['guestbook_id'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('guestbook/list_guestbook'));
	}

	public function delete_guestbook_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$guestbookId = ARequest::get('guestbook_id');
		$guestbookId = is_array($guestbookId) ? $guestbookId : explode(',', $guestbookId);
		$_L_ID = implode(', ', $guestbookId);

		foreach($guestbookId as $guestbookId) {
			$result = M('Guestbook')->delete_guestbook($guestbookId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_GUESTBOOK').': ID['.$guestbookId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('guestbook/list_guestbook'));
			}
		}

		M('Log')->add_log(L('DELETE_GUESTBOOK').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('guestbook/list_guestbook'));
	}

	public function toggle_guestbook_status_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = array();
		$data['guestbook_id'] = ARequest::get('guestbook_id');
		$data['g_status'] = ARequest::get('g_status');
		if(false === M('Guestbook')->update($data)) {
			M('Log')->add_log(L('EDIT_GUESTBOOK').': ID['.$data['guestbook_id'].']'.$result['error'], 0);
			$this->error(L('TOGGLE_FAILED'), Url::U('guestbook/list_guestbook'));
		}
		M('Log')->add_log(L('EDIT_GUESTBOOK').': ID['.$data['guestbook_id'].']');
		$this->success(L('TOGGLE_SUCCESS'), Url::U('guestbook/list_guestbook'));
	}

	public function pass_guestbook_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$guestbookId = ARequest::get('guestbook_id');
		$guestbookId = is_array($guestbookId) ? $guestbookId : explode(',', $guestbookId);
		$_L_ID = implode(', ', $guestbookId);

		foreach($guestbookId as $guestbookId) {
			$result = M('Guestbook')->pass_guestbook($guestbookId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('PASS_GUESTBOOK').': ID['.$guestbookId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('guestbook/list_guestbook'));
			}
		}

		M('Log')->add_log(L('PASS_GUESTBOOK').': ID['.$_L_ID.']');
		$this->success(L('PASS_SUCCESS'), Url::U('guestbook/list_guestbook'));
	}

	public function delete_same_ip_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$guestbookId = ARequest::get('guestbook_id');
		$guestbookId = is_array($guestbookId) ? $guestbookId : explode(',', $guestbookId);
		$_L_ID = implode(', ', $guestbookId);

		foreach($guestbookId as $guestbookId) {
			$result = M('Guestbook')->delete_same_ip($guestbookId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_GUESTBOOK').': ID['.$guestbookId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('guestbook/list_guestbook'));
			}
		}

		M('Log')->add_log(L('DELETE_GUESTBOOK').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('guestbook/list_guestbook'));
	}
}

?>