<?php

/**
 *--------------------------------------
 * menu
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-05
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class MenuCtrlr extends ManageCtrlr {
	public function list_menu() {
		$_MSL = M('MenuSpace')->get_spaceList();
		if(empty($_MSL)) {
			$this->error(L('ADD_MENU_SPACE_FIRST'), Url::U('menu_space/add_space'));
		}
		$this->assign('_MSL', $_MSL);

		/* menu space lsit */
		$msAlias = ARequest::get('ms_alias') ? ARequest::get('ms_alias') : '';
		$_ML = !empty($msAlias) ? M('Menu')->get_menuList($msAlias) : array();
		$this->assign('_ML', $_ML);

		$this->display('menu/list_menu');
	}

	public function add_menu() {
		/* menu space list */
		$_MSL = M('MenuSpace')->get_spaceList();
		if(empty($_MSL)) {
			$this->error(L('ADD_MENU_SPACE_FIRST'), Url::U('menu_space/add_space'));
		}
		$this->assign('_MSL', $_MSL);

		/* home controller list */
		$_CL = get_ctrlrList(LIB_CTRLR_PATH.D_S.'Home');
		$this->assign('_CL', $_CL);

		$this->display('menu/add_menu');
	}
	public function add_menu_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$result = M('Menu')->add_menu($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_MENU').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('menu/list_menu'));
		}
		M('Log')->add_log(L('ADD_MENU').': ID['.$result['data'].']');
		$this->success(L('ADD_SUCCESS'), Url::U('menu/list_menu?ms_alias='.$data['ms_alias']));
	}

	public function edit_menu() {
		$menuId = ARequest::get('menu_id');

		$_MI = M('Menu')->get_menuInfo($menuId);
		if(empty($_MI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('menu/list_menu'));
		}
		$this->assign('_MI', $_MI);

		/* menu space list */
		$_MSL = M('MenuSpace')->get_spaceList();
		if(empty($_MSL)) {
			$this->error(L('ADD_MENU_SPACE_FIRST'), Url::U('menu_space/add_space'));
		}
		$this->assign('_MSL', $_MSL);

		/* menu list */
		$_ML = M('Menu')->get_menuList($_MI['ms_alias']);
		$this->assign('_ML', $_ML);

		/* home controller list */
		$_CL = get_ctrlrList(LIB_CTRLR_PATH.D_S.'Home');
		$this->assign('_CL', $_CL);

		$this->display('menu/edit_menu');
	}
	public function edit_menu_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$result = M('Menu')->edit_menu($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_MENU').': ID['.$data['menu_id'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('menu/list_menu'));
		}
		M('Log')->add_log(L('EDIT_MENU').': ID['.$data['menu_id'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('menu/list_menu?ms_alias='.$data['ms_alias']));
	}

	public function update_menu_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$menuId = ARequest::get('menu_id');
		$msAlias = ARequest::get('ms_alias');
		$_L_ID = is_array($menuId) ? implode(', ', $menuId) : $menuId;

		if(empty($menuId)) {
			M('Log')->add_log(L('EDIT_MENU').': ID['.$menuId.']'.L('ITEM_INEXISTENCE'), 0);
			$this->error(L('ITEM_INEXISTENCE'), Url::U('menu/list_menu?ms_alias='.$msAlias));
		}

		$mName = ARequest::get('m_name');
		$mAlias = ARequest::get('m_alias');
		$mTip = ARequest::get('m_tip');
		$data = array();
		foreach($menuId as $k => $id) {
			$data['menu_id'] = $id;
			$data['m_name'] = $mName[$k];
			$data['m_alias'] = $mAlias[$k];
			$data['m_tip'] = $mTip[$k];
			$result = M('Menu')->edit_menu($data);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('EDIT_MENU').': ID['.$data['menu_id'].']'.$result['error'], 0);
				$this->error($result['error'], Url::U('menu/list_menu?ms_alias='.$msAlias));
			}
		}

		M('Log')->add_log(L('EDIT_MENU').': ID['.$_L_ID.']');
		$this->success(L('EDIT_SUCCESS'), Url::U('menu/list_menu?ms_alias='.$msAlias));
	}

	public function delete_menu_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$menuId = ARequest::get('menu_id');
		$msAlias = ARequest::get('ms_alias');
		$menuId = is_array($menuId) ? $menuId : explode(',', $menuId);
		$_L_ID = implode(', ', $menuId);

		foreach($menuId as $menuId) {
			$result = M('Menu')->delete_menu($menuId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_MENU').': ID['.$menuId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('menu/list_menu?ms_alias='.$msAlias));
			}
		}

		M('Log')->add_log(L('DELETE_MENU').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('menu/list_menu?ms_alias='.$msAlias));
	}

	public function _sort_menu_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$sort = ARequest::get('sort');
		$data = array();
		foreach($sort as $id => $_data) {
			$data['menu_id'] = $id;
			$data['m_parent_id'] = $_data['pid'];
			$data['m_display_order'] = $_data['order'];
			$result = M('Menu')->edit_menu($data);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('SORT_MENU').':'.$result['error'], 0);
				$this->error($result['error'], Url::U('menu/list_menu'));
			}
		}

		M('Log')->add_log(L('SORT_MENU'));
		$this->success(L('SORT_SUCCESS'), Url::U('menu/list_menu'));
	}

	/* get action from controller */
	public function _get_ctrlr_list() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$group = 'Home';
		$ctrlrList = get_ctrlrList(LIB_CTRLR_PATH.D_S.$group);
		$this->ajax_return(array('data' => $ctrlrList));
	}

	/* get action from controller */
	public function _get_actn_list() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$group = 'Home';
		$ctrlr = ARequest::get('ctrlr');
		$file = LIB_CTRLR_PATH.D_S.$group.D_S.$ctrlr.'Ctrlr.class.php';
		$actnList = get_fileActnList($file);
		$this->ajax_return(array('data' => $actnList));
	}

	/* get top menu list form alias */
	public function _get_menu_list() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$msAlias = ARequest::get('ms_alias');
		$_ML = M('Menu')->get_menuList($msAlias);
		$this->ajax_return(array('data' => $_ML));
	}
}

?>