<?php

/**
 *--------------------------------------
 * menu space
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-05
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class MenuSpaceCtrlr extends ManageCtrlr {
	public function list_space() {
		$_MSL = M('MenuSpace')->get_spaceList(false);
		$this->assign('_MSL', $_MSL);
		$this->display('menu_space/list_space');
	}

	public function add_space() {
		$this->display('menu_space/add_space');
	}
	public function add_space_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$result = M('MenuSpace')->add_space($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_MENU_SPACE').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('menu_space/list_space'));
		}
		M('Log')->add_log(L('ADD_MENU_SPACE').': ['.$result['data'].']');
		$this->success(L('ADD_SUCCESS'), Url::U('menu_space/list_space'));
	}

	public function edit_space() {
		$msAlias = ARequest::get('ms_alias');
		$_MSI = M('MenuSpace')->get_spaceInfo($msAlias, false);
		if(empty($_MSI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('menu_space/list_space'));
		}
		$this->assign('_MSI', $_MSI);

		$this->display('menu_space/edit_space');
	}
	public function edit_space_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$result = M('MenuSpace')->edit_space($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_MENU_SPACE').': ['.$data['ms_alias'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('menu_space/list_space'));
		}
		M('Log')->add_log(L('EDIT_MENU_SPACE').': ['.$data['ms_alias'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('menu_space/list_space'));
	}

	public function update_space_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$msAlias = ARequest::get('ms_alias');
		$msName = ARequest::get('ms_name');
		$_L_ID = is_array($msAlias) ? implode(', ', $msAlias) : $msAlias;

		if(!is_array($msAlias) or empty($msAlias)) {
			M('Log')->add_log(L('EDIT_MENU_SPACE').': ['.$msAlias.']'.L('ITEM_INEXISTENCE'), 0);
			$this->error(L('ITEM_INEXISTENCE'), Url::U('menu_space/list_space'));
		}

		$data = array();
		foreach($msAlias as $k => $alias) {
			$data['ms_alias'] = $alias;
			$data['ms_name'] = $msName[$k];
			$result = M('MenuSpace')->edit_space($data);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('EDIT_MENU_SPACE').': ['.$data['ms_alias'].']', 0);
				$this->error(L('EDIT_FAILED'), Url::U('menu_space/list_space'));
			}
		}

		M('Log')->add_log(L('EDIT_MENU_SPACE').': ['.$_L_ID.']');
		$this->success(L('EDIT_SUCCESS'), Url::U('menu_space/list_space'));
	}

	public function delete_space_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$msAlias = ARequest::get('ms_alias');
		$msAlias = is_array($msAlias) ? $msAlias : explode(',', $msAlias);
		$_L_ID = implode(', ', $msAlias);

		foreach($msAlias as $msAlias) {
			$result = M('MenuSpace')->delete_space($msAlias);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_MENU_SPACE').': ['.$msAlias.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('menu_space/list_space'));
			}
		}

		M('Log')->add_log(L('DELETE_MENU_SPACE').': ['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('menu_space/list_space'));
	}
}

?>