<?php

/**
 *--------------------------------------
 * single page
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class SinglePageCtrlr extends ManageCtrlr {
	public function list_single_page() {
		/* single page group lsit */
		$_SPGL = M('SinglePage')->field('sp_group')->group('sp_group')->select();
		$this->assign('_SPGL', $_SPGL);

		$spGroup = ARequest::get('sp_group') ? ARequest::get('sp_group') : '';
		$_spl = !empty($spGroup) ? M('SinglePage')->get_singlePageList($spGroup) : array();
		$act = new ATree($_spl, array('single_page_id', 'sp_parent_id', 'sp_sub_page'));

		$_SPL = $act->get_leaf(0);
		$this->assign('_SPL', $_SPL);

		$this->display('single_page/list_single_page');
	}

	public function add_single_page() {
		/* single page group lsit */
		$_SPGL = M('SinglePage')->field('sp_group')->group('sp_group')->select();
		$this->assign('_SPGL', $_SPGL);

		$spParentId = ARequest::get('sp_parent_id');

		$_SPI = array();
		if(0 < $spParentId) {
			$_SPI = M('SinglePage')->get_singlePageInfo($spParentId);
		}
		if(empty($_SPI)) {
			$_SPI = array('sp_tpl' => 'show_single_page.php');
		}
		else {
			$_SPI['sp_parent_id'] = $spParentId;
			unset($_SPI['single_page_id']);
		}
		$this->assign('_SPI', $_SPI);

		// template list
		$_C = require (CFG_PATH.D_S.'comm.php');
		$_TPLS = list_file(C('TE.TPL_PATH').D_S.$_C['TE']['TPL_THEME'].D_S.'home');
		$this->assign('_TPLS', $_TPLS);

		$this->display('single_page/add_single_page');
	}
	public function add_single_page_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$data['sp_edit_time'] = NOW_TIME;
		$data['sp_parent_id'] = intval($data['sp_parent_id']) ? intval($data['sp_parent_id']) : 0;

		$result = M('SinglePage')->add_single_page($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_SINGLE_PAGE').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('single_page/list_single_page'));
		}
		/* build now */
		$data['single_page_id'] = $result['data'];
		if(isset($data['build_now']) and 1 == $data['build_now']) {
			M('SinglePage')->build_url($data['single_page_id']);
			ARequest::set('single_page_id', $data['single_page_id']);
			ARequest::set('show_progress', 'no');
			$this->build_html_do();
		}
		M('Log')->add_log(L('ADD_SINGLE_PAGE').': ID['.$result['data'].']');
		$this->success(L('ADD_SUCCESS'), Url::U('single_page/list_single_page?sp_group='.$data['sp_group']));
	}

	public function edit_single_page() {
		/* single page group lsit */
		$_SPGL = M('SinglePage')->field('sp_group')->group('sp_group')->select();
		$this->assign('_SPGL', $_SPGL);

		$singlePageId = ARequest::get('single_page_id');

		$_SPI = M('SinglePage')->get_singlePageInfo($singlePageId);
		if(empty($_SPI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('single_page/list_single_page'));
		}
		$this->assign('_SPI', $_SPI);

		// template list
		$_C = require (CFG_PATH.D_S.'comm.php');
		$_TPLS = list_file(C('TE.TPL_PATH').D_S.$_C['TE']['TPL_THEME'].D_S.'home');
		$this->assign('_TPLS', $_TPLS);

		$this->display('single_page/edit_single_page');
	}
	public function edit_single_page_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$data['sp_edit_time'] = NOW_TIME;
		$data['sp_parent_id'] = intval($data['sp_parent_id']) ? intval($data['sp_parent_id']) : 0;

		$childIDs = array();
		$_SPI = M('SinglePage')->field('sp_group')->find($data['single_page_id']);
		if($_SPI['sp_group'] != $data['sp_group']) {
			$_SPL = M('SinglePage')->get_singlePageList($_SPI['sp_group']);
			$act = new ATree($_SPL, array('single_page_id', 'sp_parent_id', 'sp_sub_page'));
			$childIDs = $act->get_leafid($data['single_page_id']);
		}

		$result = M('SinglePage')->edit_single_page($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_SINGLE_PAGE').': ID['.$data['single_page_id'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('single_page/list_single_page'));
		}
		/* update children's group */
		foreach($childIDs as $id) {
			$_data = array();
			if($id != $data['single_page_id']) {
				$_data['single_page_id'] = $id;
				$_data['sp_group'] = $data['sp_group'];
				M('SinglePage')->edit_single_page($_data);
			}
		}
		/* build now */
		if(isset($data['build_now']) and 1 == $data['build_now']) {
			M('SinglePage')->build_url($data['single_page_id']);
			ARequest::set('single_page_id', $data['single_page_id']);
			ARequest::set('show_progress', 'no');
			$this->build_html_do();
		}
		M('Log')->add_log(L('EDIT_SINGLE_PAGE').': ID['.$data['single_page_id'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('single_page/list_single_page?sp_group='.$data['sp_group']));
	}

	public function delete_single_page_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$singlePageId = ARequest::get('single_page_id');
		$spGroup = ARequest::get('sp_group');
		$singlePageId = is_array($singlePageId) ? $singlePageId : explode(',', $singlePageId);
		$_L_ID = implode(', ', $singlePageId);

		foreach($singlePageId as $singlePageId) {
			$result = M('SinglePage')->delete_single_page($singlePageId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_SINGLE_PAGE').': ID['.$singlePageId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('single_page/list_single_page?sp_group='.$spGroup));
			}
		}

		M('Log')->add_log(L('DELETE_SINGLE_PAGE').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('single_page/list_single_page?sp_group='.$spGroup));
	}

	public function build_url_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$singlePageId = ARequest::get('single_page_id');
		$spGroup = ARequest::get('sp_group');
		$singlePageId = is_array($singlePageId) ? $singlePageId : explode(',', $singlePageId);
		$_L_ID = implode(', ', $singlePageId);

		foreach($singlePageId as $singlePageId) {
			$result = M('SinglePage')->build_url($singlePageId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('BUILD_SINGLE_PAGE_URL').': ID['.$singlePageId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('single_page/list_single_page?sp_group='.$spGroup));
			}
		}

		M('Log')->add_log(L('BUILD_SINGLE_PAGE_URL').': ID['.$_L_ID.']');
		$this->success(L('BUILD_SUCCESS'), Url::U('single_page/list_single_page?sp_group='.$spGroup));
	}

	/* build single page html */
	public function build_html_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$this->assign('_SITE',get_varSite());
		$this->assign('_G', get_varG());

		set_time_limit(99999999);
		if('no' != ARequest::get('show_progress')) {
			$this->display('cache/progress');
		}

		$singlePageId = ARequest::get('single_page_id');
		$spGroup = ARequest::get('sp_group');

		$_L_ID = is_array($singlePageId) ? implode(', ', $singlePageId) : $singlePageId;
		M('Log')->add_log(L('BUILD_SINGLE_PAGE_HTML').': ID['.$_L_ID.']');

		if(!is_array($singlePageId)) {
			$singlePageId = explode(',', $singlePageId);
		}
		sort($singlePageId);
		$rowNum = count($singlePageId);

		$_C = require (CFG_PATH.D_S.'comm.php');
		foreach($singlePageId as $key => $singlePageId) {
			$progress = round(($key + 1) / $rowNum * 100, 1);

			$_GCAP = 'home@single_page/show_single_page?single_page_id='.$singlePageId;
			$this->assign('_GCAP', $_GCAP);
			$this->assign('gcap', gcap($_GCAP));

			$_V = M('SinglePage')->get_singlePageInfo($singlePageId);
			if(empty($_V) or !$_V['sp_is_html'] or empty($_V['sp_html_naming'])) {
				if('no' != ARequest::get('show_progress')) {
					M('Cache')->show_progress($progress.'% ['.($key + 1).'/'.$rowNum.']: '.L('SKIP'), $progress);
				}
				continue;
			}
			/* single page group:root */
			$_spl = M('SinglePage')->get_singlePageList($_V['sp_group']);
			$spt = new ATree($_spl, array('single_page_id', 'sp_parent_id', 'sp_sub_page'));
			$_V['sp_tree'] = $spt->get_leaf(0);
			$this->assign('_V', $_V);

			/* current group */
			$this->assign('GROUP', $_V['sp_group']);
			$this->assign('SP_ID', $_V['single_page_id']);
			$this->assign('_CP', $_V['sp_position']);

			$rootUrl = C('LANG.DETECT') ? $_V['lang'].'/' : '';
			$file = '/'.trim(str_replace(array('{root_url}'), array($rootUrl), $_V['sp_html_naming']), '/');

			$this->te->tplTheme = $_C['TE']['TPL_THEME'];
			C('TE.SKIN_STYLE', $_C['TE']['SKIN_STYLE']);
			$this->build_html($file.C('URL.FILE_SUFFIX'), ROOT_PATH, 'home/'.$_V['sp_tpl']);
			C('TE.SKIN_STYLE', 'admin');
			$this->te->tplTheme = 'admin';

			if('no' != ARequest::get('show_progress')) {
				M('Cache')->show_progress($progress.'% ['.($key + 1).'/'.$rowNum.']: '.$_V['sp_title'].' '.L('BUILD_COMPLETE'), $progress);
			}
		}

		set_time_limit(30);
		if('no' != ARequest::get('show_progress')) {
			M('Cache')->show_direction(Url::U('single_page/list_single_page?sp_group='.$spGroup));
		}
	}

	/* sort single page */
	public function _sort_single_page_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$sort = ARequest::get('sort');
		$data = array();
		foreach($sort as $id => $_data) {
			$data['single_page_id'] = $id;
			$data['sp_parent_id'] = $_data['pid'];
			$data['sp_display_order'] = $_data['order'];
			$result = M('SinglePage')->edit_single_page($data);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('SORT_SINGLE_PAGE').': '.$result['error'], 0);
				$this->error($result['error'], Url::U('single_page/list_single_page'));
			}
		}

		M('Log')->add_log(L('SORT_SINGLE_PAGE'));
		$this->success(L('SORT_SUCCESS'), Url::U('single_page/list_single_page'));
	}

	/* get single page list select */
	public function _get_single_page_select() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$data = array('data' => 0);

		$spGroup = ARequest::get('sp_group');
		$_SPL = $spGroup ? M('SinglePage')->get_singlePageList($spGroup) : array();

		$singlePageId = intval(ARequest::get('single_page_id'));
		$selectType = 'current' == ARequest::get('select_type') ? 'current' : 'sub';
		$exclude = !preg_match('/[^\d\,]/i', ARequest::get('exclude')) ? explode(',', ARequest::get('exclude')) : array();

		$singlePageSelect = M('SinglePage')->get_singlePageSelect($_SPL, $singlePageId, $selectType, $exclude);
		$data = array('data' => 1, 'info' => $singlePageSelect);
		$this->ajax_return($data);
	}

	/* get single page group */
	public function _get_group() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$data = array('data' => 0);

		$singlePageId = intval(ARequest::get('single_page_id'));
		$_SPI = M('SinglePage')->field('sp_group')->find($singlePageId);
		$data = array('data' => 1, 'info' => $_SPI['sp_group']);
		$this->ajax_return($data);
	}

	/* get single page html naming */
	public function _get_html_naming() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$data = array('data' => 0);

		$singlePageId = intval(ARequest::get('single_page_id'));
		$_SPI = M('SinglePage')->field('sp_html_naming')->find($singlePageId);
		$htmlNaming = !empty($_SPI['sp_html_naming']) ? $_SPI['sp_html_naming'] : '{root_url}';

		$spTitle = ARequest::get('sp_title');
		$sp_py = '';
		if(!empty($spTitle)) {
			vendor('Pinyin#class');
			$pyc = get_instance('Pinyin');
			$sp_py = strtolower(str_replace(' ', '', $pyc->get_pinyin($spTitle, 'utf-8')));
		}
		if(!empty($sp_py)) {
			$htmlNaming .= ('{root_url}' == $htmlNaming) ? $sp_py : '/'.$sp_py;
		}

		$data = array('data' => 1, 'info' => $htmlNaming);
		$this->ajax_return($data);
	}
}

?>