<?php

/**
 *--------------------------------------
 * search
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-10
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class SearchCtrlr extends IndexCtrlr {
	public function search_do() {
		$_o_i = M('Option')->get_option('interaction');

		/* check search switch */
		if(!$_o_i['search_switch']) {
			halt(L('SEARCH_IS_OFF'), true, true);
		}

		if(!I('search', $_o_i['search_interval'])) {
			$this->error(L('_TRY_LATER_'), Url::U('index/index'));
		}

		$this->assign('_GCAP', 'home@index/index');

		/* analysis keywords */
		$keyword = AString::msubstr(AFilter::keyword(ARequest::get('keyword')), 32);
		if(1 > AString::mstrlen($keyword)) {
			$this->error(L('KEYWORD_TOO_SHORT'), Url::U('index/index'));
		}
		$keywords = M('Search')->analysis_keywords($keyword);
		$keyword = implode(' ', $keywords);
		$this->assign('keyword', $keyword);

		/* get paging and list */
		$pageSign = md5('S|'.LANG_NAME.'|'.$keyword.'|'.intval($_GET[C('VAR.PAGE')]));
		$_PG = S('_PG'.$pageSign);
		$_L = S('_L'.$pageSign);
		if(empty($_L)) {
			$rowsNum = M('Search')->count_article($keywords);
			if(0 < $rowsNum) {
				$pageSize = M('Option')->get_option('index/page_size');
				$_GET[C('VAR.PAGE')] = intval(ARequest::get(C('VAR.PAGE'))) ? intval(ARequest::get(C('VAR.PAGE'))) : 1;
				$p = new APage($rowsNum, $pageSize, Url::U('search/search_do?keyword='.urlencode($keyword).'&'.C('VAR.PAGE').'=_page_'));
				$_PG = $p->get_paging();

				$_L = M('Search')->search($keywords, $p->get_limit());
				S('_PG'.$pageSign, $_PG);
				S('_L'.$pageSign, $_L);
			}
		}
		$this->assign('_PG', $_PG);
		$this->assign('_L', $_L);

		I('search');
		/* current position */
		$this->assign('_CP', array(
			array('name' => L('HOME'), 'url' => Url::U('home@index/index')),
			array('name' => L('SEARCH'), 'url' => ''),
			array('name' => $keyword, 'url' => ''))
		);

		if(IS_AJAX) {
			$this->display('home/ajax/keyword');
		}
		else {
			$this->display('home/keyword');
		}
	}

}

?>